/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.spi.JtaManager;
import org.jboss.as.jpa.spi.ManagementAdaptor;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.jpa.transaction.JtaManagerImpl;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class PersistenceProviderAdaptorLoader {
    private static final PersistenceProviderAdaptor noopAdaptor = new PersistenceProviderAdaptor(){

        public void injectJtaManager(JtaManager jtaManager) {
        }

        public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        }

        public void addProviderDependencies(ServiceRegistry registry, ServiceTarget target, ServiceBuilder<?> builder, PersistenceUnitMetadata pu) {
        }

        public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        }

        public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        }

        public ManagementAdaptor getManagementAdaptor() {
            return null;
        }

        public void cleanup(PersistenceUnitMetadata pu) {
        }
    };

    public static PersistenceProviderAdaptor loadPersistenceAdapterModule(String adapterModule) throws ModuleLoadException {
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        if (adapterModule == null) {
            return noopAdaptor;
        }
        PersistenceProviderAdaptor persistenceProviderAdaptor = null;
        Module module = moduleLoader.loadModule(ModuleIdentifier.fromString((String)adapterModule));
        ServiceLoader serviceLoader = module.loadService(PersistenceProviderAdaptor.class);
        if (serviceLoader != null) {
            for (PersistenceProviderAdaptor adaptor : serviceLoader) {
                if (persistenceProviderAdaptor != null) {
                    throw JpaMessages.MESSAGES.multipleAdapters(adapterModule);
                }
                persistenceProviderAdaptor = adaptor;
                JpaLogger.JPA_LOGGER.debugf("loaded persistence provider adapter %s", (Object)adapterModule);
            }
            if (persistenceProviderAdaptor != null) {
                persistenceProviderAdaptor.injectJtaManager(JtaManagerImpl.getInstance());
            }
        }
        return persistenceProviderAdaptor;
    }
}

