/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.infinispan.CacheException;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.remote.RemoteCacheStore;
import org.infinispan.util.FileLookup;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteCacheStoreConfig
extends AbstractCacheStoreConfig {
    private volatile String remoteCacheName;
    private static final Log log = LogFactory.getLog(RemoteCacheStoreConfig.class);
    private final Properties hotRodClientProperties = new Properties();
    private ExecutorFactory asyncExecutorFactory = null;

    public RemoteCacheStoreConfig() {
        this.setCacheLoaderClassName(RemoteCacheStore.class.getName());
    }

    public void setRemoteCacheName(String remoteCacheName) {
        this.remoteCacheName = remoteCacheName;
    }

    public String getRemoteCacheName() {
        return this.remoteCacheName;
    }

    public void setUseDefaultRemoteCache(boolean useDefaultRemoteCache) {
        if (useDefaultRemoteCache) {
            this.setRemoteCacheName("___defaultcache");
        }
    }

    public boolean isUseDefaultRemoteCache() {
        return "___defaultcache".equals(this.getRemoteCacheName());
    }

    public Properties getHotRodClientProperties() {
        return this.hotRodClientProperties;
    }

    public void setHotRodClientProperties(Properties props) {
        this.hotRodClientProperties.putAll((Map<?, ?>)props);
    }

    public ExecutorFactory getAsyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    public void setAsyncExecutorFactory(ExecutorFactory asyncExecutorFactory) {
        this.asyncExecutorFactory = asyncExecutorFactory;
    }

    public void setHotRodClientPropertiesFile(String hotRodClientPropertiesFile) {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        InputStream inputStream = fileLookup.lookupFile(hotRodClientPropertiesFile, this.getClassLoader());
        try {
            this.hotRodClientProperties.load(inputStream);
        }
        catch (IOException e) {
            log.error((Object)("Issues while loading properties from file " + hotRodClientPropertiesFile), (Throwable)e);
            throw new CacheException((Throwable)e);
        }
        finally {
            Util.close((Closeable)inputStream);
        }
    }
}

