/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.LegacyGlobalConfigurationAdaptor;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.Event;
import org.jboss.as.clustering.infinispan.AbstractAdvancedCache;

public class DefaultEmbeddedCacheManager
extends AbstractDelegatingEmbeddedCacheManager {
    private final String defaultCache;
    static final Map<Event.Type, Class<? extends Annotation>> events = new EnumMap<Event.Type, Class<? extends Annotation>>(Event.Type.class);

    private static GlobalConfiguration adapt(org.infinispan.configuration.global.GlobalConfiguration config) {
        GlobalConfiguration global = LegacyGlobalConfigurationAdaptor.adapt((org.infinispan.configuration.global.GlobalConfiguration)config);
        global.fluent().globalJmxStatistics().cacheManagerName(config.globalJmxStatistics().cacheManagerName());
        return global;
    }

    private static org.infinispan.configuration.global.GlobalConfiguration adapt(GlobalConfiguration global) {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder().read(LegacyGlobalConfigurationAdaptor.adapt((GlobalConfiguration)global));
        return builder.globalJmxStatistics().cacheManagerName(global.getCacheManagerName()).build();
    }

    public DefaultEmbeddedCacheManager(org.infinispan.configuration.global.GlobalConfiguration global, String defaultCache) {
        this((EmbeddedCacheManager)new DefaultCacheManager(DefaultEmbeddedCacheManager.adapt(global), false), defaultCache);
    }

    public DefaultEmbeddedCacheManager(org.infinispan.configuration.global.GlobalConfiguration global, Configuration config, String defaultCache) {
        this((EmbeddedCacheManager)new DefaultCacheManager(DefaultEmbeddedCacheManager.adapt(global), LegacyConfigurationAdaptor.adapt((Configuration)config), false), defaultCache);
    }

    public DefaultEmbeddedCacheManager(EmbeddedCacheManager container, String defaultCache) {
        super(container);
        this.defaultCache = defaultCache;
    }

    @Deprecated
    public org.infinispan.config.Configuration defineConfiguration(String cacheName, org.infinispan.config.Configuration configurationOverride) {
        return this.cm.defineConfiguration(this.getCacheName(cacheName), configurationOverride);
    }

    @Deprecated
    public org.infinispan.config.Configuration defineConfiguration(String cacheName, String templateCacheName, org.infinispan.config.Configuration configurationOverride) {
        return this.cm.defineConfiguration(this.getCacheName(cacheName), this.getCacheName(templateCacheName), configurationOverride);
    }

    public Configuration defineConfiguration(String cacheName, Configuration configuration) {
        return this.cm.defineConfiguration(this.getCacheName(cacheName), configuration);
    }

    public <K, V> Cache<K, V> getCache() {
        return this.getCache(this.defaultCache);
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, true);
    }

    public <K, V> Cache<K, V> getCache(String cacheName, boolean start) {
        Cache cache = this.cm.getCache(this.getCacheName(cacheName), start);
        return cache != null ? new DelegatingCache(cache) : null;
    }

    public Set<String> getCacheNames() {
        HashSet<String> names = new HashSet<String>(this.cm.getCacheNames());
        names.add(this.defaultCache);
        return names;
    }

    public boolean isDefaultRunning() {
        return this.cm.isRunning(this.defaultCache);
    }

    public boolean isRunning(String cacheName) {
        return this.cm.isRunning(this.getCacheName(cacheName));
    }

    public boolean cacheExists(String cacheName) {
        return this.cm.cacheExists(this.getCacheName(cacheName));
    }

    public void removeCache(String cacheName) {
        this.cm.removeCache(this.getCacheName(cacheName));
    }

    public EmbeddedCacheManager startCaches(String ... names) {
        LinkedHashSet<String> cacheNames = new LinkedHashSet<String>();
        for (String name : names) {
            cacheNames.add(this.getCacheName(name));
        }
        this.cm.startCaches(cacheNames.toArray(new String[cacheNames.size()]));
        return this;
    }

    private String getCacheName(String name) {
        return name == null || name.equals("___defaultcache") ? this.defaultCache : name;
    }

    public org.infinispan.configuration.global.GlobalConfiguration getCacheManagerConfiguration() {
        return DefaultEmbeddedCacheManager.adapt(this.getGlobalConfiguration());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.cm.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName();
    }

    static ClassLoader getContextClassLoader() {
        PrivilegedAction<ClassLoader> action = new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        return AccessController.doPrivileged(action);
    }

    static void setContextClassLoader(final ClassLoader loader) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(loader);
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    static {
        events.put(Event.Type.CACHE_ENTRY_ACTIVATED, CacheEntryActivated.class);
        events.put(Event.Type.CACHE_ENTRY_CREATED, CacheEntryCreated.class);
        events.put(Event.Type.CACHE_ENTRY_INVALIDATED, CacheEntryInvalidated.class);
        events.put(Event.Type.CACHE_ENTRY_LOADED, CacheEntryLoaded.class);
        events.put(Event.Type.CACHE_ENTRY_MODIFIED, CacheEntryModified.class);
        events.put(Event.Type.CACHE_ENTRY_PASSIVATED, CacheEntryPassivated.class);
        events.put(Event.Type.CACHE_ENTRY_REMOVED, CacheEntryRemoved.class);
        events.put(Event.Type.CACHE_ENTRY_VISITED, CacheEntryVisited.class);
    }

    private class ClassLoaderAwareCommandInterceptor
    extends CommandInterceptor {
        private final AdvancedCache<?, ?> cache;

        ClassLoaderAwareCommandInterceptor(AdvancedCache<?, ?> cache) {
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            ClassLoader classLoader = this.cache.getClassLoader();
            ClassLoader contextLoader = DefaultEmbeddedCacheManager.getContextClassLoader();
            if (classLoader != null) {
                DefaultEmbeddedCacheManager.setContextClassLoader(classLoader);
            }
            try {
                Object object = super.handleDefault(ctx, command);
                return object;
            }
            finally {
                if (classLoader != null) {
                    DefaultEmbeddedCacheManager.setContextClassLoader(contextLoader);
                }
            }
        }
    }

    @Listener
    public static class ClassLoaderAwareListener {
        private final Object listener;
        private final Map<Event.Type, List<Method>> methods = new EnumMap<Event.Type, List<Method>>(Event.Type.class);
        private final AdvancedCache<?, ?> cache;

        public ClassLoaderAwareListener(Object listener, AdvancedCache<?, ?> cache) {
            this.listener = listener;
            this.cache = cache;
            for (Method method : listener.getClass().getMethods()) {
                for (Map.Entry<Event.Type, Class<? extends Annotation>> entry : events.entrySet()) {
                    Class<? extends Annotation> annotation = entry.getValue();
                    if (!method.isAnnotationPresent(annotation)) continue;
                    List<Method> methods = this.methods.get(entry.getValue());
                    if (methods == null) {
                        methods = new LinkedList<Method>();
                        this.methods.put(entry.getKey(), methods);
                    }
                    methods.add(method);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @CacheEntryActivated
        @CacheEntryCreated
        @CacheEntryInvalidated
        @CacheEntryLoaded
        @CacheEntryModified
        @CacheEntryPassivated
        @CacheEntryRemoved
        @CacheEntryVisited
        public <K, V> void event(Event<K, V> event) throws Throwable {
            List<Method> methods = this.methods.get(event.getType());
            if (methods == null) return;
            ClassLoader cacheLoader = this.cache.getClassLoader();
            ClassLoader contextLoader = DefaultEmbeddedCacheManager.getContextClassLoader();
            if (cacheLoader != null) {
                DefaultEmbeddedCacheManager.setContextClassLoader(cacheLoader);
            }
            try {
                for (Method method : this.methods.get(event.getType())) {
                    try {
                        method.invoke(this.listener, event);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                        return;
                    }
                }
            }
            finally {
                if (cacheLoader != null) {
                    DefaultEmbeddedCacheManager.setContextClassLoader(contextLoader);
                }
            }
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof ClassLoaderAwareListener) {
                ClassLoaderAwareListener listener = (ClassLoaderAwareListener)object;
                return this.listener.equals(listener.listener);
            }
            return this.listener.equals(object);
        }
    }

    class DelegatingCache<K, V>
    extends AbstractAdvancedCache<K, V> {
        DelegatingCache(AdvancedCache<K, V> cache) {
            super(cache);
        }

        DelegatingCache(Cache<K, V> cache) {
            this(cache.getAdvancedCache());
        }

        @Override
        protected AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
            return new DelegatingCache<K, V>(cache);
        }

        public EmbeddedCacheManager getCacheManager() {
            return DefaultEmbeddedCacheManager.this;
        }

        public void addListener(Object listener) {
            super.addListener((Object)new ClassLoaderAwareListener(listener, (AdvancedCache<?, ?>)this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AdvancedCache<K, V> with(ClassLoader classLoader) {
            AdvancedCache cache = super.with(classLoader);
            ClassLoaderAwareCommandInterceptor interceptor = new ClassLoaderAwareCommandInterceptor(cache);
            DelegatingCache delegatingCache = this;
            synchronized (delegatingCache) {
                try {
                    this.cache.addInterceptor((CommandInterceptor)interceptor, 0);
                }
                catch (ConfigurationException e) {
                    this.cache.removeInterceptor(((Object)((Object)interceptor)).getClass());
                    this.cache.addInterceptor((CommandInterceptor)interceptor, 0);
                }
            }
            return cache;
        }

        public synchronized void addInterceptor(CommandInterceptor interceptor, int position) {
            super.addInterceptor(interceptor, position > 0 ? position : 1);
        }

        public synchronized boolean addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
            return super.addInterceptorAfter(i, afterInterceptor);
        }

        public synchronized boolean addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
            return super.addInterceptorBefore(i, beforeInterceptor);
        }

        public synchronized void removeInterceptor(int position) {
            super.removeInterceptor(position);
        }

        public synchronized void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
            super.removeInterceptor(interceptorType);
        }

        public boolean equals(Object object) {
            return object == this || object == this.cache;
        }

        public int hashCode() {
            return this.cache.hashCode();
        }
    }
}

