/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.clustering.infinispan.subsystem.SelfRegisteringAttributeHandler;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class CacheConfigOperationHandlers {
    static final OperationStepHandler LOCKING_ADD = new BasicCacheConfigAdd(CommonAttributes.LOCKING_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler LOCKING_ATTR = new AttributeWriteHandler(CommonAttributes.LOCKING_ATTRIBUTES);
    static final OperationStepHandler TRANSACTION_ADD = new BasicCacheConfigAdd(CommonAttributes.TRANSACTION_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler TRANSACTION_ATTR = new AttributeWriteHandler(CommonAttributes.TRANSACTION_ATTRIBUTES);
    static final OperationStepHandler EVICTION_ADD = new BasicCacheConfigAdd(CommonAttributes.EVICTION_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler EVICTION_ATTR = new AttributeWriteHandler(CommonAttributes.EVICTION_ATTRIBUTES);
    static final OperationStepHandler EXPIRATION_ADD = new BasicCacheConfigAdd(CommonAttributes.EXPIRATION_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler EXPIRATION_ATTR = new AttributeWriteHandler(CommonAttributes.EXPIRATION_ATTRIBUTES);
    static final OperationStepHandler STATE_TRANSFER_ADD = new BasicCacheConfigAdd(CommonAttributes.STATE_TRANSFER_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler STATE_TRANSFER_ATTR = new AttributeWriteHandler(CommonAttributes.STATE_TRANSFER_ATTRIBUTES);
    static final OperationStepHandler STORE_ADD = new CacheStoreAdd();
    static final SelfRegisteringAttributeHandler STORE_ATTR = new AttributeWriteHandler(CommonAttributes.COMMON_STORE_ATTRIBUTES, CommonAttributes.STORE_ATTRIBUTES);
    static final OperationStepHandler STORE_WRITE_BEHIND_ADD = new BasicCacheConfigAdd(CommonAttributes.WRITE_BEHIND_ATTRIBUTES);
    static final SelfRegisteringAttributeHandler STORE_WRITE_BEHIND_ATTR = new AttributeWriteHandler(CommonAttributes.WRITE_BEHIND_ATTRIBUTES);
    static final OperationStepHandler FILE_STORE_ADD = new FileCacheStoreAdd();
    static final SelfRegisteringAttributeHandler FILE_STORE_ATTR = new AttributeWriteHandler(CommonAttributes.COMMON_STORE_ATTRIBUTES, CommonAttributes.FILE_STORE_ATTRIBUTES);
    static final OperationStepHandler STRING_KEYED_JDBC_STORE_ADD = new StringKeyedJDBCCacheStoreAdd();
    static final SelfRegisteringAttributeHandler STRING_KEYED_JDBC_STORE_ATTR = new AttributeWriteHandler(CommonAttributes.COMMON_STORE_ATTRIBUTES, CacheConfigOperationHandlers.combine(CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES, CommonAttributes.STRING_KEYED_JDBC_STORE_ATTRIBUTES));
    static final OperationStepHandler BINARY_KEYED_JDBC_STORE_ADD = new BinaryKeyedJDBCCacheStoreAdd();
    static final SelfRegisteringAttributeHandler BINARY_KEYED_JDBC_STORE_ATTR = new AttributeWriteHandler(CommonAttributes.COMMON_STORE_ATTRIBUTES, CacheConfigOperationHandlers.combine(CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES, CommonAttributes.BINARY_KEYED_JDBC_STORE_ATTRIBUTES));
    static final OperationStepHandler MIXED_KEYED_JDBC_STORE_ADD = new MixedKeyedJDBCCacheStoreAdd();
    static final SelfRegisteringAttributeHandler MIXED_KEYED_JDBC_STORE_ATTR = new AttributeWriteHandler(CommonAttributes.COMMON_STORE_ATTRIBUTES, CacheConfigOperationHandlers.combine(CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES, CommonAttributes.MIXED_KEYED_JDBC_STORE_ATTRIBUTES));
    static final OperationStepHandler REMOTE_STORE_ADD = new RemoteCacheStoreAdd();
    static final SelfRegisteringAttributeHandler REMOTE_STORE_ATTR = new AttributeWriteHandler(CommonAttributes.COMMON_STORE_ATTRIBUTES, CommonAttributes.REMOTE_STORE_ATTRIBUTES);
    static final OperationStepHandler REMOVE = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
            CacheConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };
    static final OperationStepHandler STORE_PROPERTY_ADD = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            CommonAttributes.VALUE.validateAndSet(operation, resource.getModel());
            CacheConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };
    static final OperationStepHandler STORE_PROPERTY_ATTR = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            CommonAttributes.VALUE.validateAndSet(operation, resource.getModel());
            CacheConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }
    };

    static ModelNode createOperation(AttributeDefinition[] attributes, ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        for (AttributeDefinition attribute : attributes) {
            attribute.validateAndSet(existing, operation);
        }
        return operation;
    }

    static ModelNode createStoreOperation(AttributeDefinition[] commonAttributes, ModelNode address, ModelNode existing, AttributeDefinition ... additionalAttributes) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        for (AttributeDefinition attribute : commonAttributes) {
            attribute.validateAndSet(existing, operation);
        }
        for (AttributeDefinition attribute : additionalAttributes) {
            attribute.validateAndSet(existing, operation);
        }
        return operation;
    }

    static ModelNode createStringKeyedStoreOperation(ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        for (AttributeDefinition attribute : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attribute.validateAndSet(existing, operation);
        }
        for (AttributeDefinition attribute : CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES) {
            attribute.validateAndSet(existing, operation);
        }
        for (AttributeDefinition attribute : CommonAttributes.STRING_KEYED_JDBC_STORE_ATTRIBUTES) {
            attribute.validateAndSet(existing, operation);
        }
        return operation;
    }

    static ModelNode createBinaryKeyedStoreOperation(ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        for (AttributeDefinition attribute : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attribute.validateAndSet(existing, operation);
        }
        for (AttributeDefinition attribute : CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES) {
            attribute.validateAndSet(existing, operation);
        }
        for (AttributeDefinition attribute : CommonAttributes.BINARY_KEYED_JDBC_STORE_ATTRIBUTES) {
            attribute.validateAndSet(existing, operation);
        }
        return operation;
    }

    static ModelNode createMixedKeyedStoreOperation(ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        for (AttributeDefinition attribute : CommonAttributes.COMMON_STORE_ATTRIBUTES) {
            attribute.validateAndSet(existing, operation);
        }
        for (AttributeDefinition attribute : CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES) {
            attribute.validateAndSet(existing, operation);
        }
        for (AttributeDefinition attribute : CommonAttributes.MIXED_KEYED_JDBC_STORE_ATTRIBUTES) {
            attribute.validateAndSet(existing, operation);
        }
        return operation;
    }

    static void reloadRequiredStep(OperationContext context) {
        if (context.getProcessType().isServer() && !context.isBooting()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        context.revertReloadRequired();
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static PathAddress getCacheAddress(ModelNode operation) {
        PathAddress cacheStoreAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress cacheAddress = cacheStoreAddress.subAddress(0, cacheStoreAddress.size() - 1);
        return cacheAddress;
    }

    private static ModelNode getCache(OperationContext context, PathAddress cacheAddress) {
        ModelNode cache = Resource.Tools.readModel((Resource)context.readResourceFromRoot(cacheAddress));
        return cache;
    }

    private static Resource getCacheResource(OperationContext context, PathAddress cacheAddress) {
        Resource rootResource = context.readResourceFromRoot(cacheAddress, true);
        return rootResource;
    }

    private static boolean isCacheStoreDefined(OperationContext context, ModelNode operation) {
        ModelNode cache = CacheConfigOperationHandlers.getCache(context, CacheConfigOperationHandlers.getCacheAddress(operation));
        return CacheConfigOperationHandlers.hasCustomStore(cache) || CacheConfigOperationHandlers.hasFileStore(cache) || CacheConfigOperationHandlers.hasStringKeyedJdbcStore(cache) || CacheConfigOperationHandlers.hasBinaryKeyedJdbcStore(cache) || CacheConfigOperationHandlers.hasMixedKeyedJdbcStore(cache) || CacheConfigOperationHandlers.hasRemoteStore(cache);
    }

    private static String getDefinedCacheStore(OperationContext context, ModelNode operation) {
        ModelNode cache = CacheConfigOperationHandlers.getCache(context, CacheConfigOperationHandlers.getCacheAddress(operation));
        if (CacheConfigOperationHandlers.hasCustomStore(cache)) {
            return "store";
        }
        if (CacheConfigOperationHandlers.hasFileStore(cache)) {
            return "file-store";
        }
        if (CacheConfigOperationHandlers.hasStringKeyedJdbcStore(cache)) {
            return "string-keyed-jdbc-store";
        }
        if (CacheConfigOperationHandlers.hasBinaryKeyedJdbcStore(cache)) {
            return "binary-keyed-jdbc-store";
        }
        if (CacheConfigOperationHandlers.hasMixedKeyedJdbcStore(cache)) {
            return "mixed-keyed-jdbc-store";
        }
        if (CacheConfigOperationHandlers.hasRemoteStore(cache)) {
            return "remote-store";
        }
        return null;
    }

    private static boolean hasCustomStore(ModelNode cache) {
        return cache.hasDefined("store") && cache.get(new String[]{"store", "STORE"}).isDefined();
    }

    private static boolean hasFileStore(ModelNode cache) {
        return cache.hasDefined("file-store") && cache.get(new String[]{"file-store", "FILE_STORE"}).isDefined();
    }

    private static boolean hasStringKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("string-keyed-jdbc-store") && cache.get(new String[]{"string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasBinaryKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("binary-keyed-jdbc-store") && cache.get(new String[]{"binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasMixedKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("mixed-keyed-jdbc-store") && cache.get(new String[]{"mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasRemoteStore(ModelNode cache) {
        return cache.hasDefined("remote-store") && cache.get(new String[]{"remote-store", "REMOTE_STORE"}).isDefined();
    }

    private static AttributeDefinition[] combine(AttributeDefinition[] one, AttributeDefinition[] two) {
        ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>(Arrays.asList(one));
        list.addAll(Arrays.asList(two));
        AttributeDefinition[] allValueTypes = new AttributeDefinition[list.size()];
        list.toArray(allValueTypes);
        return allValueTypes;
    }

    static class AttributeWriteHandler
    extends ReloadRequiredWriteAttributeHandler
    implements SelfRegisteringAttributeHandler {
        final AttributeDefinition[] attributes;

        private AttributeWriteHandler(AttributeDefinition[] attributes) {
            super(attributes);
            this.attributes = attributes;
        }

        private AttributeWriteHandler(AttributeDefinition[] attributes, AttributeDefinition ... moreAttributes) {
            this(CacheConfigOperationHandlers.combine(attributes, moreAttributes));
        }

        @Override
        public void registerAttributes(ManagementResourceRegistration registry) {
            EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
            for (AttributeDefinition attr : this.attributes) {
                registry.registerReadWriteAttribute(attr.getName(), null, (OperationStepHandler)this, flags);
            }
        }
    }

    private static class RemoteCacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = CommonAttributes.REMOTE_STORE_ATTRIBUTES;

        RemoteCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class MixedKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] attributes = CommonAttributes.MIXED_KEYED_JDBC_STORE_ATTRIBUTES;

        MixedKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class BinaryKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] attributes = CommonAttributes.BINARY_KEYED_JDBC_STORE_ATTRIBUTES;

        BinaryKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class StringKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] attributes = CommonAttributes.STRING_KEYED_JDBC_STORE_ATTRIBUTES;

        StringKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class JDBCCacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = CommonAttributes.COMMON_JDBC_STORE_ATTRIBUTES;

        JDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class FileCacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = CommonAttributes.FILE_STORE_ATTRIBUTES;

        FileCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class CacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = CommonAttributes.STORE_ATTRIBUTES;

        CacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    static abstract class AbstractCacheStoreAdd
    extends AbstractAddStepHandler {
        private final AttributeDefinition[] attributes = CommonAttributes.COMMON_STORE_ATTRIBUTES;

        AbstractCacheStoreAdd() {
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            if (CacheConfigOperationHandlers.isCacheStoreDefined(context, operation)) {
                String storeName = CacheConfigOperationHandlers.getDefinedCacheStore(context, operation);
                throw new OperationFailedException(new ModelNode().set("cache store " + storeName + " is already defined"));
            }
            for (AttributeDefinition attribute : this.attributes) {
                if (attribute.getName().equals(CommonAttributes.PROPERTIES.getName())) continue;
                attribute.validateAndSet(operation, model);
            }
            this.populateSubclassModel(context, operation, model);
            if (operation.hasDefined("properties")) {
                for (Property property : operation.get("properties").asPropertyList()) {
                    Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"property", (String)property.getName())}));
                    ModelNode value = property.getValue();
                    if (!value.isDefined()) {
                        throw new OperationFailedException(new ModelNode().set("property " + property.getName() + " not defined"));
                    }
                    param.getModel().get("value").set(value);
                }
            }
        }

        abstract void populateSubclassModel(OperationContext var1, ModelNode var2, ModelNode var3) throws OperationFailedException;

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        }
    }

    private static class BasicCacheConfigAdd
    implements OperationStepHandler,
    DescriptionProvider {
        private final AttributeDefinition[] attributes;

        BasicCacheConfigAdd(AttributeDefinition[] attributes) {
            this.attributes = attributes;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            ModelNode subModel = resource.getModel();
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, subModel);
            }
            this.process(subModel, operation);
            CacheConfigOperationHandlers.reloadRequiredStep(context);
            context.completeStep();
        }

        void process(ModelNode subModel, ModelNode operation) {
        }

        public ModelNode getModelDescription(Locale locale) {
            return new ModelNode().set("description");
        }
    }
}

