/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.AggregatingNotifyingFutureImpl;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFutureImpl;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;

public class AggregatingNotifyingFutureBuilder
extends NotifyingFutureImpl {
    final List<Future<Object>> futures;

    public AggregatingNotifyingFutureBuilder(Object actualReturnValue, int capacity) {
        super(actualReturnValue);
        this.futures = new ArrayList<Future<Object>>(capacity);
    }

    public NotifyingNotifiableFuture build() {
        AggregatingNotifyingFutureImpl notifyingAggregateFuture = new AggregatingNotifyingFutureImpl(this.actualReturnValue, this.futures.size());
        for (FutureListener futureListener : this.listeners) {
            notifyingAggregateFuture.attachListener(futureListener);
        }
        for (Future future : this.futures) {
            notifyingAggregateFuture.setNetworkFuture(future);
        }
        return notifyingAggregateFuture;
    }

    @Override
    public void setNetworkFuture(Future<Object> future) {
        this.futures.add(future);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean aggregateValue = false;
        for (Future<Object> f : this.futures) {
            aggregateValue = f.cancel(mayInterruptIfRunning) && aggregateValue;
        }
        return aggregateValue;
    }

    @Override
    public boolean isCancelled() {
        for (Future<Object> f : this.futures) {
            if (!f.isCancelled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDone() {
        for (Future<Object> f : this.futures) {
            if (f.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        for (Future<Object> f : this.futures) {
            f.get();
        }
        return this.actualReturnValue;
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        for (Future<Object> f : this.futures) {
            f.get(timeout, unit);
        }
        return this.actualReturnValue;
    }

    @Override
    public void notifyDone() {
    }
}

