/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.ArgumentValueConverter;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.ModelNodeFormatter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class GenericTypeOperationHandler
extends BatchModeCommandHandler {
    protected final String commandName;
    protected final String idProperty;
    protected final String nodeType;
    protected final ArgumentWithValue profile;
    protected final ArgumentWithValue name;
    protected final ArgumentWithValue operation;
    protected final List<String> excludeOps;
    protected final ArgumentWithoutValue helpProperties;
    protected final ArgumentWithoutValue helpCommands;
    private final List<CommandArgument> staticArgs = new ArrayList<CommandArgument>();
    private Map<String, CommandArgument> nodeProps;
    private Map<String, Map<String, CommandArgument>> propsByOp;
    private Map<String, ArgumentValueConverter> propConverters;
    private Map<String, CommandLineCompleter> valueCompleters;

    public GenericTypeOperationHandler(CommandContext ctx, String nodeType, String idProperty) {
        this(ctx, nodeType, idProperty, Arrays.asList("read-attribute", "read-children-names", "read-children-resources", "read-children-types", "read-operation-description", "read-operation-names", "read-resource-description", "validate-address", "write-attribute", "undefine-attribute"));
    }

    public GenericTypeOperationHandler(CommandContext ctx, String nodeType, String idProperty, List<String> excludeOperations) {
        super(ctx, "generic-type-operation", true);
        if (nodeType == null || nodeType.isEmpty()) {
            throw new IllegalArgumentException("Node type is " + (nodeType == null ? "null." : "empty."));
        }
        if (nodeType.startsWith("/profile=") || nodeType.startsWith("profile=")) {
            int nextSep = nodeType.indexOf(47, 7);
            if (nextSep < 0) {
                throw new IllegalArgumentException("Failed to determine the path after the profile in '" + nodeType + "'.");
            }
            this.nodeType = nodeType = nodeType.substring(nextSep);
        } else {
            this.nodeType = nodeType;
        }
        this.helpArg = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--help", "-h");
        this.addRequiredPath(nodeType);
        this.commandName = this.getRequiredType();
        if (this.commandName == null) {
            throw new IllegalArgumentException("The node path doesn't end on a type: '" + nodeType + "'");
        }
        this.idProperty = idProperty;
        this.excludeOps = excludeOperations;
        this.profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
            }
        }), "--profile"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!GenericTypeOperationHandler.this.isDependsOnProfile()) {
                    return false;
                }
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.operation = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode()) {
                    String profileName = GenericTypeOperationHandler.this.profile.getValue(ctx.getParsedCommandLine());
                    if (profileName == null) {
                        return Collections.emptyList();
                    }
                    address.toNode("profile", profileName);
                }
                for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.getRequiredAddress()) {
                    address.toNode(node.getType(), node.getName());
                }
                address.toNode(GenericTypeOperationHandler.this.getRequiredType(), "?");
                Collection<String> ops = ctx.getOperationCandidatesProvider().getOperationNames(ctx, address);
                ops.removeAll(GenericTypeOperationHandler.this.excludeOps);
                return ops;
            }
        }), 0, "--operation"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode() && !GenericTypeOperationHandler.this.profile.isValueComplete(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.operation.addCantAppearAfter(this.helpArg);
        this.name = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            public List<String> getAllCandidates(CommandContext ctx) {
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    return Collections.emptyList();
                }
                DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode()) {
                    String profileName = GenericTypeOperationHandler.this.profile.getValue(ctx.getParsedCommandLine());
                    if (GenericTypeOperationHandler.this.profile == null) {
                        return Collections.emptyList();
                    }
                    address.toNode("profile", profileName);
                }
                for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.getRequiredAddress()) {
                    address.toNode(node.getType(), node.getName());
                }
                return Util.getNodeNames(ctx.getModelControllerClient(), address, GenericTypeOperationHandler.this.getRequiredType());
            }
        }), idProperty == null ? "--name" : "--" + idProperty){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode() && !GenericTypeOperationHandler.this.profile.isValueComplete(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.name.addCantAppearAfter(this.helpArg);
        this.helpArg.addCantAppearAfter(this.name);
        this.helpProperties = new ArgumentWithoutValue(this, "--properties");
        this.helpProperties.addRequiredPreceding(this.helpArg);
        this.helpProperties.addCantAppearAfter(this.operation);
        this.helpCommands = new ArgumentWithoutValue(this, "--commands");
        this.helpCommands.addRequiredPreceding(this.helpArg);
        this.helpCommands.addCantAppearAfter(this.operation);
        this.helpCommands.addCantAppearAfter(this.helpProperties);
        this.helpProperties.addCantAppearAfter(this.helpCommands);
        this.staticArgs.add(this.helpArg);
        this.staticArgs.add(this.helpCommands);
        this.staticArgs.add(this.helpProperties);
        this.staticArgs.add(this.profile);
        this.staticArgs.add(this.name);
        this.staticArgs.add(this.operation);
    }

    public void addValueConverter(String propertyName, ArgumentValueConverter converter) {
        if (this.propConverters == null) {
            this.propConverters = new HashMap<String, ArgumentValueConverter>();
        }
        this.propConverters.put(propertyName, converter);
    }

    public void addValueCompleter(String propertyName, CommandLineCompleter completer) {
        if (this.valueCompleters == null) {
            this.valueCompleters = new HashMap<String, CommandLineCompleter>();
        }
        this.valueCompleters.put(propertyName, completer);
    }

    @Override
    public Collection<CommandArgument> getArguments(CommandContext ctx) {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        try {
            if (!this.name.isValueComplete(args)) {
                return this.staticArgs;
            }
        }
        catch (CommandFormatException e) {
            return Collections.emptyList();
        }
        String op = this.operation.getValue(args);
        return this.loadArguments(ctx, op).values();
    }

    private Map<String, CommandArgument> loadArguments(CommandContext ctx, String op) {
        Map<String, CommandArgument> opProps;
        if (op == null) {
            if (this.nodeProps == null) {
                List<Object> propList;
                try {
                    propList = this.getNodeProperties(ctx);
                }
                catch (CommandFormatException e) {
                    propList = Collections.emptyList();
                }
                HashMap<String, CommandArgument> argMap = new HashMap<String, CommandArgument>(propList.size());
                for (int i = 0; i < propList.size(); ++i) {
                    Property prop = (Property)propList.get(i);
                    ModelNode propDescr = prop.getValue();
                    if (!propDescr.has("access-type") || !"read-write".equals(propDescr.get("access-type").asString())) continue;
                    ModelType type = null;
                    CommandLineCompleter valueCompleter = null;
                    ArgumentValueConverter valueConverter = null;
                    if (this.propConverters != null) {
                        valueConverter = this.propConverters.get(prop.getName());
                    }
                    if (this.valueCompleters != null) {
                        valueCompleter = this.valueCompleters.get(prop.getName());
                    }
                    if (valueConverter == null) {
                        valueConverter = ArgumentValueConverter.DEFAULT;
                        if (propDescr.has("type")) {
                            type = propDescr.get("type").asType();
                            if (ModelType.BOOLEAN == type) {
                                if (valueCompleter == null) {
                                    valueCompleter = SimpleTabCompleter.BOOLEAN;
                                }
                            } else if (prop.getName().endsWith("properties")) {
                                valueConverter = ArgumentValueConverter.PROPERTIES;
                            } else if (ModelType.LIST == type) {
                                valueConverter = propDescr.hasDefined("value-type") && propDescr.get("value-type").asType() == ModelType.PROPERTY ? ArgumentValueConverter.PROPERTIES : ArgumentValueConverter.LIST;
                            } else if (ModelType.OBJECT == type) {
                                valueConverter = ArgumentValueConverter.OBJECT;
                            }
                        }
                    }
                    ArgumentWithValue arg = new ArgumentWithValue((CommandHandlerWithArguments)this, valueCompleter, valueConverter, "--" + prop.getName());
                    argMap.put(arg.getFullName(), arg);
                }
                this.nodeProps = argMap;
                this.nodeProps.put(this.headers.getFullName(), this.headers);
            }
            return this.nodeProps;
        }
        if (this.propsByOp == null) {
            this.propsByOp = new HashMap<String, Map<String, CommandArgument>>();
        }
        if ((opProps = this.propsByOp.get(op)) == null) {
            ModelNode descr;
            try {
                descr = this.getOperationDescription(ctx, op);
            }
            catch (CommandFormatException e1) {
                return Collections.emptyMap();
            }
            opProps = new HashMap<String, CommandArgument>();
            opProps.put(this.headers.getFullName(), this.headers);
            if (descr != null && descr.has("request-properties")) {
                List propList = descr.get("request-properties").asPropertyList();
                opProps = new HashMap<String, CommandArgument>(propList.size());
                for (Property prop : propList) {
                    ModelNode propDescr = prop.getValue();
                    ModelType type = null;
                    CommandLineCompleter valueCompleter = null;
                    ArgumentValueConverter valueConverter = null;
                    if (this.propConverters != null) {
                        valueConverter = this.propConverters.get(prop.getName());
                    }
                    if (this.valueCompleters != null) {
                        valueCompleter = this.valueCompleters.get(prop.getName());
                    }
                    if (valueConverter == null) {
                        valueConverter = ArgumentValueConverter.DEFAULT;
                        if (propDescr.has("type")) {
                            type = propDescr.get("type").asType();
                            if (ModelType.BOOLEAN == type) {
                                if (valueCompleter == null) {
                                    valueCompleter = SimpleTabCompleter.BOOLEAN;
                                }
                            } else if (prop.getName().endsWith("properties")) {
                                valueConverter = ArgumentValueConverter.PROPERTIES;
                            } else if (ModelType.LIST == type) {
                                valueConverter = propDescr.hasDefined("value-type") && propDescr.get("value-type").asType() == ModelType.PROPERTY ? ArgumentValueConverter.PROPERTIES : ArgumentValueConverter.LIST;
                            } else if (ModelType.OBJECT == type) {
                                valueConverter = ArgumentValueConverter.OBJECT;
                            }
                        }
                    }
                    ArgumentWithValue arg = new ArgumentWithValue((CommandHandlerWithArguments)this, valueCompleter, valueConverter, "--" + prop.getName());
                    opProps.put(arg.getFullName(), arg);
                }
            }
            this.propsByOp.put(op, opProps);
        }
        return opProps;
    }

    @Override
    public boolean hasArgument(String name) {
        return true;
    }

    @Override
    public boolean hasArgument(int index) {
        return true;
    }

    @Override
    public void addArgument(CommandArgument arg) {
    }

    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        String operation = this.operation.getValue(ctx.getParsedCommandLine());
        if (operation == null) {
            return this.buildWritePropertyRequest(ctx);
        }
        return this.buildOperationRequest(ctx, operation);
    }

    @Override
    protected void handleResponse(CommandContext ctx, ModelNode opResponse, boolean composite) throws CommandFormatException {
        if (!Util.isSuccess(opResponse)) {
            throw new CommandFormatException(Util.getFailureDescription(opResponse));
        }
        StringBuilder buf = this.formatResponse(ctx, opResponse, composite, null);
        if (buf != null) {
            ctx.printLine(buf.toString());
        }
    }

    protected StringBuilder formatResponse(CommandContext ctx, ModelNode opResponse, boolean composite, StringBuilder buf) throws CommandFormatException {
        if (!opResponse.hasDefined("result")) {
            return null;
        }
        ModelNode result = opResponse.get("result");
        if (composite) {
            Set keys;
            try {
                keys = result.keys();
            }
            catch (Exception e) {
                throw new CommandFormatException("Failed to get step results from a composite operation response " + opResponse);
            }
            for (String key : keys) {
                ModelNode stepResponse = result.get(key);
                buf = this.formatResponse(ctx, stepResponse, false, buf);
            }
        } else {
            ModelNodeFormatter.ModelNodeFormatterBase formatter = ModelNodeFormatter.Factory.forType(result.getType());
            if (buf == null) {
                buf = new StringBuilder();
            }
            formatter.format(buf, 0, result);
        }
        return buf;
    }

    protected ModelNode buildWritePropertyRequest(CommandContext ctx) throws CommandFormatException {
        String profile;
        String name = this.name.getValue(ctx.getParsedCommandLine(), true);
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (this.isDependsOnProfile() && ctx.isDomainMode()) {
            profile = this.profile.getValue(args);
            if (profile == null) {
                throw new OperationFormatException("--profile argument value is missing.");
            }
        } else {
            profile = null;
        }
        Map<String, CommandArgument> nodeProps = this.loadArguments(ctx, null);
        for (String argName : args.getPropertyNames()) {
            if (this.isDependsOnProfile() && argName.equals("--profile") || this.name.getFullName().equals(argName)) continue;
            ArgumentWithValue arg = (ArgumentWithValue)nodeProps.get(argName);
            if (arg == null) {
                throw new CommandFormatException("Unrecognized argument name '" + argName + "'");
            }
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            if (profile != null) {
                builder.addNode("profile", profile);
            }
            for (OperationRequestAddress.Node node : this.getRequiredAddress()) {
                builder.addNode(node.getType(), node.getName());
            }
            builder.addNode(this.getRequiredType(), name);
            builder.setOperationName("write-attribute");
            String propName = argName.charAt(1) == '-' ? argName.substring(2) : argName.substring(1);
            builder.addProperty("name", propName);
            String valueString = args.getPropertyValue(argName);
            ModelNode nodeValue = arg.getValueConverter().fromString(valueString);
            builder.getModelNode().get("value").set(nodeValue);
            steps.add(builder.buildRequest());
        }
        return composite;
    }

    protected ModelNode buildOperationRequest(CommandContext ctx, String operation) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        if (this.isDependsOnProfile() && ctx.isDomainMode()) {
            String profile = this.profile.getValue(args);
            if (profile == null) {
                throw new OperationFormatException("Required argument --profile is missing.");
            }
            builder.addNode("profile", profile);
        }
        String name = this.name.getValue(ctx.getParsedCommandLine(), true);
        for (OperationRequestAddress.Node node : this.getRequiredAddress()) {
            builder.addNode(node.getType(), node.getName());
        }
        builder.addNode(this.getRequiredType(), name);
        builder.setOperationName(operation);
        Map<String, CommandArgument> argsMap = this.loadArguments(ctx, operation);
        for (String argName : args.getPropertyNames()) {
            if (this.isDependsOnProfile() && argName.equals("--profile")) continue;
            if (argsMap == null) {
                if (argName.equals(this.name.getFullName())) continue;
                throw new CommandFormatException("Command '" + operation + "' is not expected to have arguments other than " + this.name.getFullName() + ".");
            }
            ArgumentWithValue arg = (ArgumentWithValue)argsMap.get(argName);
            if (arg == null) {
                if (argName.equals(this.name.getFullName())) continue;
                throw new CommandFormatException("Unrecognized argument " + argName + " for command '" + operation + "'.");
            }
            String propName = argName.charAt(1) == '-' ? argName.substring(2) : argName.substring(1);
            String valueString = args.getPropertyValue(argName);
            ModelNode nodeValue = arg.getValueConverter().fromString(valueString);
            builder.getModelNode().get(propName).set(nodeValue);
        }
        return builder.buildRequest();
    }

    @Override
    protected void printHelp(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (this.helpProperties.isPresent(args)) {
            this.printProperties(ctx, this.getNodeProperties(ctx));
            return;
        }
        if (this.helpCommands.isPresent(args)) {
            this.printCommands(ctx);
            return;
        }
        String operationName = this.operation.getValue(args);
        if (operationName == null) {
            this.printNodeDescription(ctx);
            return;
        }
        try {
            ModelNode result = this.getOperationDescription(ctx, operationName);
            if (!result.hasDefined("description")) {
                throw new CommandFormatException("Operation description is not available.");
            }
            StringBuilder buf = new StringBuilder();
            buf.append("\nDESCRIPTION:\n\n");
            buf.append(result.get("description").asString());
            ctx.printLine(buf.toString());
            if (result.hasDefined("request-properties")) {
                this.printProperties(ctx, result.get("request-properties").asPropertyList());
            } else {
                this.printProperties(ctx, Collections.<Property>emptyList());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void printProperties(CommandContext ctx, List<Property> props) {
        int spaces;
        StringBuilder prop;
        LinkedHashMap<String, StringBuilder> requiredProps = new LinkedHashMap<String, StringBuilder>();
        requiredProps.put(this.name.getFullName(), new StringBuilder().append("Required argument in commands which identifies the instance to execute the command against."));
        LinkedHashMap<String, StringBuilder> optionalProps = new LinkedHashMap<String, StringBuilder>();
        String accessType = null;
        for (Property attr : props) {
            String type;
            ModelNode value = attr.getValue();
            if (value.has("access-type")) {
                accessType = value.get("access-type").asString();
            }
            boolean required = value.hasDefined("required") ? value.get("required").asBoolean() : false;
            StringBuilder descr = new StringBuilder();
            String string = type = value.has("type") ? value.get("type").asString() : "no type info";
            if (value.hasDefined("description")) {
                descr.append('(');
                descr.append(type);
                if (accessType != null) {
                    descr.append(',').append(accessType);
                }
                descr.append(") ");
                descr.append(value.get("description").asString());
            } else if (descr.length() == 0) {
                descr.append("no description.");
            }
            if (required) {
                if (this.idProperty != null && this.idProperty.equals(attr.getName())) {
                    if (descr.charAt(descr.length() - 1) != '.') {
                        descr.append('.');
                    }
                    ((StringBuilder)requiredProps.get(this.name.getFullName())).insert(0, ' ').insert(0, descr.toString());
                    continue;
                }
                requiredProps.put("--" + attr.getName(), descr);
                continue;
            }
            optionalProps.put("--" + attr.getName(), descr);
        }
        ctx.printLine("\n");
        if (accessType == null) {
            ctx.printLine("REQUIRED ARGUMENTS:\n");
        }
        for (String argName : requiredProps.keySet()) {
            prop = new StringBuilder();
            prop.append(' ').append(argName);
            spaces = 28 - prop.length();
            do {
                prop.append(' ');
            } while (--spaces >= 0);
            prop.append("- ").append((CharSequence)requiredProps.get(argName));
            ctx.printLine(prop.toString());
        }
        if (!optionalProps.isEmpty()) {
            if (accessType == null) {
                ctx.printLine("\n\nOPTIONAL ARGUMENTS:\n");
            }
            for (String argName : optionalProps.keySet()) {
                prop = new StringBuilder();
                prop.append(' ').append(argName);
                spaces = 28 - prop.length();
                do {
                    prop.append(' ');
                } while (--spaces >= 0);
                prop.append("- ").append((CharSequence)optionalProps.get(argName));
                ctx.printLine(prop.toString());
            }
        }
    }

    protected void printNodeDescription(CommandContext ctx) throws CommandFormatException {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("\nSYNOPSIS\n\n");
        buf.append(this.commandName).append(" --help [--properties | --commands] |\n");
        for (i = 0; i <= this.commandName.length(); ++i) {
            buf.append(' ');
        }
        buf.append(this.name.getFullName()).append("=<value> --<property>=<value> (--<property>=<value>)* |\n");
        for (i = 0; i <= this.commandName.length(); ++i) {
            buf.append(' ');
        }
        buf.append("<command> ").append(this.name.getFullName()).append("=<value> (--<parameter>=<value>)*");
        if (ctx.isDomainMode()) {
            buf.append('\n');
            for (i = 0; i <= this.commandName.length(); ++i) {
                buf.append(' ');
            }
            buf.append("[--headers={operation_header (;operation_header)*}]");
        }
        buf.append("\n\nDESCRIPTION\n\n");
        buf.append("The command is used to manage resources of type " + this.nodeType + ".");
        buf.append("\n\nRESOURCE DESCRIPTION\n\n");
        if (this.isDependsOnProfile() && ctx.isDomainMode() && this.profile.getValue(ctx.getParsedCommandLine()) == null) {
            buf.append("(Execute '");
            buf.append(this.commandName).append(" --profile=<profile_name> --help' to include the resource description here.)");
        } else {
            ModelNode request = this.initRequest(ctx);
            if (request == null) {
                return;
            }
            request.get("operation").set("read-resource-description");
            ModelNode result = null;
            try {
                result = ctx.getModelControllerClient().execute(request);
                if (!result.hasDefined("result")) {
                    throw new CommandFormatException("Node description is not available.");
                }
                if (!(result = result.get("result")).hasDefined("description")) {
                    throw new CommandFormatException("Node description is not available.");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result != null) {
                buf.append(result.get("description").asString());
            } else {
                buf.append("N/A. Please, open a jira issue at https://issues.jboss.org/browse/AS7 to get this fixed. Thanks!");
            }
        }
        buf.append("\n\nARGUMENTS\n");
        buf.append("\n--help                - prints this content.");
        buf.append("\n--help --properties   - prints the list of the resource properties including their access-type");
        buf.append("\n                        (read/write/metric), value type, and the description.");
        buf.append("\n--help --commands     - prints the list of the commands available for the resource.");
        buf.append("\n                        To get the complete description of a specific command (including its parameters,");
        buf.append("\n                        their types and descriptions), execute ").append(this.commandName).append(" <command> --help.");
        buf.append("\n\n").append(this.name.getFullName()).append("   - ");
        if (this.idProperty == null) {
            buf.append("is the name of the resource that completes the path ").append(this.nodeType).append(" and \n");
        } else {
            buf.append("corresponds to a property of the resource which \n");
        }
        for (i = 0; i < this.name.getFullName().length() + 5; ++i) {
            buf.append(' ');
        }
        buf.append("is used to identify the resource against which the command should be executed.");
        buf.append("\n\n<property>   - property name of the resource whose value should be updated.");
        buf.append("\n               For a complete list of available property names, their types and descriptions,");
        buf.append("\n               execute ").append(this.commandName).append(" --help --properties.");
        buf.append("\n\n<command>    - command name provided by the resource. For a complete list of available commands,");
        buf.append("\n               execute ").append(this.commandName).append(" --help --commands.");
        buf.append("\n\n<parameter>  - parameter name of the <command> provided by the resource.");
        buf.append("\n               For a complete list of available parameter names of a specific <command>,");
        buf.append("\n               their types and descriptions, execute ").append(this.commandName).append(" <command> --help.");
        if (ctx.isDomainMode()) {
            buf.append("\n\n--headers    - a list of operation headers separated by a semicolon. For the list of supported");
            buf.append("\n               headers, please, refer to the domain management documentation or use tab-completion.");
        }
        ctx.printLine(buf.toString());
    }

    protected void printCommands(CommandContext ctx) throws CommandFormatException {
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return;
        }
        request.get("operation").set("read-operation-names");
        try {
            ModelNode result = ctx.getModelControllerClient().execute(request);
            if (!result.hasDefined("result")) {
                throw new CommandFormatException("Operation names aren't available.");
            }
            List<String> list = Util.getList(result);
            list.removeAll(this.excludeOps);
            list.add("To read the description of a specific command execute '" + this.commandName + " command_name --help'.");
            for (String name : list) {
                ctx.printLine(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected List<Property> getNodeProperties(CommandContext ctx) throws CommandFormatException {
        ModelNode result;
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return Collections.emptyList();
        }
        request.get("operation").set("read-resource-description");
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        if (!result.hasDefined("result")) {
            return Collections.emptyList();
        }
        if (!(result = result.get("result")).hasDefined("attributes")) {
            return Collections.emptyList();
        }
        return result.get("attributes").asPropertyList();
    }

    protected ModelNode getOperationDescription(CommandContext ctx, String operationName) throws CommandFormatException {
        ModelNode result;
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return null;
        }
        request.get("operation").set("read-operation-description");
        request.get("name").set(operationName);
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to execute read-operation-description.", e);
        }
        if (!result.hasDefined("result")) {
            return null;
        }
        return result.get("result");
    }

    protected ModelNode initRequest(CommandContext ctx) throws CommandFormatException {
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        if (this.isDependsOnProfile() && ctx.isDomainMode()) {
            String profileName = this.profile.getValue(ctx.getParsedCommandLine());
            if (profileName == null) {
                throw new CommandFormatException("WARNING: --profile argument is required for the complete description.");
            }
            address.add("profile", profileName);
        }
        for (OperationRequestAddress.Node node : this.getRequiredAddress()) {
            address.add(node.getType(), node.getName());
        }
        address.add(this.getRequiredType(), "?");
        return request;
    }
}

