/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.WSSPolicyException;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;

public class AlgorithmSuite
extends AbstractSecurityAssertion {
    private static final Logger LOG = LogUtils.getL7dLogger(AlgorithmSuite.class);
    protected String algoSuiteString;
    protected String symmetricSignature = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    protected String asymmetricSignature = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    protected String computedKey = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
    protected int maximumSymmetricKeyLength = 256;
    protected int minimumAsymmetricKeyLength = 1024;
    protected int maximumAsymmetricKeyLength = 4096;
    protected String digest;
    protected String encryption;
    protected String symmetricKeyWrap;
    protected String asymmetricKeyWrap;
    protected String encryptionKeyDerivation;
    protected int encryptionDerivedKeyLength;
    protected String signatureKeyDerivation;
    protected int signatureDerivedKeyLength;
    protected int minimumSymmetricKeyLength;
    protected String c14n = "http://www.w3.org/2001/10/xml-exc-c14n#";
    protected String soapNormalization;
    protected String strTransform;
    protected String xPath;

    public AlgorithmSuite(SPConstants version) {
        super(version);
    }

    public AlgorithmSuite() {
        super(SP12Constants.INSTANCE);
    }

    public String getAsymmetricKeyWrap() {
        return this.asymmetricKeyWrap;
    }

    public String getAsymmetricSignature() {
        return this.asymmetricSignature;
    }

    public String getComputedKey() {
        return this.computedKey;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public String getEncryptionKeyDerivation() {
        return this.encryptionKeyDerivation;
    }

    public int getMaximumAsymmetricKeyLength() {
        return this.maximumAsymmetricKeyLength;
    }

    public int getMaximumSymmetricKeyLength() {
        return this.maximumSymmetricKeyLength;
    }

    public int getMinimumAsymmetricKeyLength() {
        return this.minimumAsymmetricKeyLength;
    }

    public int getMinimumSymmetricKeyLength() {
        return this.minimumSymmetricKeyLength;
    }

    public String getSignatureKeyDerivation() {
        return this.signatureKeyDerivation;
    }

    public String getSymmetricKeyWrap() {
        return this.symmetricKeyWrap;
    }

    public String getSymmetricSignature() {
        return this.symmetricSignature;
    }

    public String getInclusiveC14n() {
        return this.c14n;
    }

    public void setC14n(String c14n) {
        this.c14n = c14n;
    }

    public String getSoapNormalization() {
        return this.soapNormalization;
    }

    public void setSoapNormalization(String soapNormalization) {
        this.soapNormalization = soapNormalization;
    }

    public String getStrTransform() {
        return this.strTransform;
    }

    public void setStrTransform(String strTransform) {
        this.strTransform = strTransform;
    }

    public String getXPath() {
        return this.xPath;
    }

    public void setXPath(String path) {
        this.xPath = path;
    }

    private void setAlgoSuiteString(String algoSuiteString) {
        this.algoSuiteString = algoSuiteString;
    }

    private String getAlgoSuiteString() {
        return this.algoSuiteString;
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getAlgorithmSuite();
    }

    public QName getRealName() {
        return this.constants.getAlgorithmSuite();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String wspPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (wspPrefix == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(wspPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        writer.writeStartElement(prefix, this.getAlgoSuiteString(), namespaceURI);
        writer.writeEndElement();
        if ("http://www.w3.org/2001/10/xml-c14n#".equals(this.getInclusiveC14n())) {
            writer.writeStartElement(prefix, "InclusiveC14N", namespaceURI);
            writer.writeEndElement();
        }
        if ("http://www.w3.org/TR/soap12-n11n".equals(this.getSoapNormalization())) {
            writer.writeStartElement(prefix, "SoapNormalization10", namespaceURI);
            writer.writeEndElement();
        }
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(this.getStrTransform())) {
            writer.writeStartElement(prefix, "STRTransform10", namespaceURI);
            writer.writeEndElement();
        }
        if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(this.getXPath())) {
            writer.writeStartElement(prefix, "XPath10", namespaceURI);
            writer.writeEndElement();
        }
        if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(this.getXPath())) {
            writer.writeStartElement(prefix, "XPathFilter20", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public int getEncryptionDerivedKeyLength() {
        return this.encryptionDerivedKeyLength;
    }

    public int getSignatureDerivedKeyLength() {
        return this.signatureDerivedKeyLength;
    }

    public void setAsymmetricKeyWrap(String asymmetricKeyWrap) {
        this.asymmetricKeyWrap = asymmetricKeyWrap;
    }

    public void setAlgorithmSuite(String algoSuite) throws WSSPolicyException {
        this.setAlgoSuiteString(algoSuite);
        this.algoSuiteString = algoSuite;
        if ("Basic256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 256;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 256;
            this.encryptionDerivedKeyLength = 256;
        } else if ("Basic192".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic128".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 128;
            this.signatureDerivedKeyLength = 128;
            this.minimumSymmetricKeyLength = 128;
        } else if ("TripleDes".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 256;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 256;
        } else if ("Basic192Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic128Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 128;
            this.signatureDerivedKeyLength = 128;
            this.minimumSymmetricKeyLength = 128;
        } else if ("TripleDesRsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic256Sha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 256;
            this.signatureDerivedKeyLength = 256;
            this.minimumSymmetricKeyLength = 256;
        } else if ("Basic192Sha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic128Sha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 128;
            this.signatureDerivedKeyLength = 128;
            this.minimumSymmetricKeyLength = 128;
        } else if ("TripleDesSha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic256Sha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 256;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 256;
        } else if ("Basic192Sha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
        } else if ("Basic128Sha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 128;
            this.signatureDerivedKeyLength = 128;
            this.minimumSymmetricKeyLength = 128;
        } else if ("TripleDesSha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
        } else {
            throw new WSSPolicyException(new Message("INVALID_ALGORITHM", LOG, new Object[]{algoSuite}));
        }
    }
}

