/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class CreateQueueMessage
extends PacketImpl {
    private static final Logger log = Logger.getLogger(CreateQueueMessage.class);
    private SimpleString address;
    private SimpleString queueName;
    private SimpleString filterString;
    private boolean durable;
    private boolean temporary;
    private boolean requiresResponse;

    public CreateQueueMessage(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary, boolean requiresResponse) {
        super((byte)34);
        this.address = address;
        this.queueName = queueName;
        this.filterString = filterString;
        this.durable = durable;
        this.temporary = temporary;
        this.requiresResponse = requiresResponse;
    }

    public CreateQueueMessage() {
        super((byte)34);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", address=" + this.address);
        buff.append(", queueName=" + this.queueName);
        buff.append(", filterString=" + this.filterString);
        buff.append(", durable=" + this.durable);
        buff.append(", temporary=" + this.temporary);
        buff.append("]");
        return buff.toString();
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public SimpleString getQueueName() {
        return this.queueName;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeSimpleString(this.address);
        buffer.writeSimpleString(this.queueName);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeBoolean(this.durable);
        buffer.writeBoolean(this.temporary);
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.address = buffer.readSimpleString();
        this.queueName = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        this.durable = buffer.readBoolean();
        this.temporary = buffer.readBoolean();
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CreateQueueMessage)) {
            return false;
        }
        CreateQueueMessage r = (CreateQueueMessage)other;
        return super.equals(other) && r.address.equals(this.address) && r.queueName.equals(this.queueName) && (r.filterString == null ? this.filterString == null : r.filterString.equals(this.filterString)) && r.durable == this.durable && r.temporary == this.temporary;
    }
}

