/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.blueprint;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.blueprint.AbstractBPBeanDefinitionParser;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.manager.DeliveryAssuranceType;
import org.apache.cxf.ws.rm.manager.DestinationPolicyType;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;
import org.apache.cxf.ws.rm.policy.RMAssertion;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMBPBeanDefinitionParser
extends AbstractBPBeanDefinitionParser {
    protected static final String RM_NS = "http://cxf.apache.org/ws/rm/manager";
    private static final Logger LOG = LogUtils.getL7dLogger(RMBPBeanDefinitionParser.class);
    private Map<Class<?>, JAXBContext> jaxbContexts = new HashMap();
    private Class<?> beanClass;

    public RMBPBeanDefinitionParser(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    protected Metadata parse(Element element, ParserContext context) {
        MutableBeanMetadata bean = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        bean.setRuntimeClass(this.beanClass);
        String bus = element.getAttribute("bus");
        if (StringUtils.isEmpty((String)bus)) {
            bus = "cxf";
        }
        this.mapElementToJaxbProperty(context, bean, element, new QName(RM_NS, "deliveryAssurance"), "deliveryAssurance", DeliveryAssuranceType.class);
        this.mapElementToJaxbProperty(context, bean, element, new QName(RM_NS, "sourcePolicy"), "sourcePolicy", SourcePolicyType.class);
        this.mapElementToJaxbProperty(context, bean, element, new QName(RM_NS, "destinationPolicy"), "destinationPolicy", DestinationPolicyType.class);
        this.mapElementToJaxbProperty(context, bean, element, new QName("http://schemas.xmlsoap.org/ws/2005/02/rm/policy", "RMAssertion"), "RMAssertion", RMAssertion.class);
        this.mapElementToJaxbProperty(context, bean, element, new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "RMAssertion"), "RMAssertion", RMAssertion.class);
        this.parseAttributes(element, context, bean);
        this.parseChildElements(element, context, bean);
        bean.setId(this.beanClass.getName() + context.generateId());
        if (this.beanClass.equals(RMManager.class)) {
            bean.addProperty("bus", (Metadata)this.getBusRef(context, bus));
            bean.setDestroyMethod("shutdown");
        }
        return bean;
    }

    protected void mapElement(ParserContext ctx, MutableBeanMetadata bean, Element el, String name) {
        if ("store".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        } else if ("addressingNamespace".equals(name)) {
            bean.addProperty("addressingNamespace", (Metadata)RMBPBeanDefinitionParser.createValue((ParserContext)ctx, (String)el.getTextContent()));
        }
    }

    protected void mapElementToJaxbProperty(ParserContext ctx, MutableBeanMetadata bean, Element parent, QName name, String propertyName, Class<?> c) {
        Element data = DOMUtils.getFirstElement((Node)parent);
        try {
            Unmarshaller unmarshaller = this.getJAXBContext(c).createUnmarshaller();
            MutablePassThroughMetadata value = (MutablePassThroughMetadata)ctx.createMetadata(MutablePassThroughMetadata.class);
            value.setObject(unmarshaller.unmarshal((Node)data, c).getValue());
            bean.addProperty(propertyName, (Metadata)value);
        }
        catch (JAXBException e) {
            LOG.warning("Unable to parse property " + propertyName + " due to " + (Object)((Object)e));
        }
    }

    private synchronized JAXBContext getJAXBContext(Class<?> c) throws JAXBException {
        JAXBContext jaxbContext = this.jaxbContexts.get(c);
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)PackageUtils.getPackageName(c), (ClassLoader)c.getClassLoader());
            this.jaxbContexts.put(c, jaxbContext);
        }
        return jaxbContext;
    }
}

