/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.filter.ClassFilter;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.ModuleLoaderProvider;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.SystemPathsProvider;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleClassLoader;
import org.jboss.osgi.framework.internal.HostBundleFallbackLoader;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.NativeResourceLoader;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.RevisionContentResourceLoader;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.metadata.NativeLibrary;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequireBundleRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XWire;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

final class ModuleManagerPlugin
extends AbstractPluginService<ModuleManagerPlugin> {
    final Logger log = Logger.getLogger(ModuleManagerPlugin.class);
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<SystemPathsProvider> injectedSystemPaths = new InjectedValue();
    private final InjectedValue<ModuleLoaderProvider> injectedModuleLoader = new InjectedValue();
    private Map<ModuleIdentifier, AbstractBundleRevision> modules = new ConcurrentHashMap<ModuleIdentifier, AbstractBundleRevision>();

    static void addService(ServiceTarget serviceTarget) {
        ModuleManagerPlugin service = new ModuleManagerPlugin();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.MODULE_MANGER_PLUGIN, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(Services.MODULE_LOADER_PROVIDER, ModuleLoaderProvider.class, service.injectedModuleLoader);
        builder.addDependency(Services.SYSTEM_PATHS_PROVIDER, SystemPathsProvider.class, service.injectedSystemPaths);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private ModuleManagerPlugin() {
    }

    public ModuleManagerPlugin getValue() {
        return this;
    }

    ModuleLoaderProvider getModuleLoaderIntegration() {
        return (ModuleLoaderProvider)this.injectedModuleLoader.getValue();
    }

    ModuleLoader getModuleLoader() {
        return this.getModuleLoaderIntegration().getModuleLoader();
    }

    ModuleIdentifier getModuleIdentifier(XModule resModule) {
        if (resModule == null) {
            throw new IllegalArgumentException("Null resModule");
        }
        if (resModule.isFragment()) {
            throw new IllegalArgumentException("A fragment is not a module");
        }
        ModuleIdentifier identifier = (ModuleIdentifier)resModule.getAttachment(ModuleIdentifier.class);
        if (identifier != null) {
            return identifier;
        }
        XModuleIdentity moduleId = resModule.getModuleId();
        Module module = (Module)resModule.getAttachment(Module.class);
        if (module != null) {
            identifier = module.getIdentifier();
        }
        if (identifier == null && "system.bundle".equals(moduleId.getName())) {
            identifier = this.getFrameworkModule().getIdentifier();
        }
        if (identifier == null) {
            identifier = this.getModuleLoaderIntegration().getModuleIdentifier(resModule);
        }
        resModule.addAttachment(ModuleIdentifier.class, (Object)identifier);
        return identifier;
    }

    Module getModule(ModuleIdentifier identifier) {
        try {
            return this.getModuleLoader().loadModule(identifier);
        }
        catch (ModuleLoadException ex) {
            return null;
        }
    }

    AbstractBundleRevision getBundleRevision(ModuleIdentifier identifier) {
        return this.modules.get(identifier);
    }

    AbstractBundleState getBundleState(ModuleIdentifier identifier) {
        AbstractBundleRevision bundleRevision = this.getBundleRevision(identifier);
        return bundleRevision != null ? bundleRevision.getBundleState() : null;
    }

    AbstractBundleState getBundleState(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        AbstractBundleState result = null;
        ClassLoader loader = clazz.getClassLoader();
        if (loader instanceof BundleReference) {
            BundleReference bundleRef = (BundleReference)loader;
            result = AbstractBundleState.assertBundleState(bundleRef.getBundle());
        } else if (loader instanceof ModuleClassLoader) {
            ModuleClassLoader moduleCL = (ModuleClassLoader)loader;
            result = this.getBundleState(moduleCL.getModule().getIdentifier());
        }
        if (result == null) {
            this.log.debugf("Cannot obtain bundle for: %s", (Object)clazz.getName());
        }
        return result;
    }

    ModuleIdentifier addModule(XModule resModule) {
        if (resModule == null) {
            throw new IllegalArgumentException("Null module");
        }
        Bundle bundle = (Bundle)resModule.getAttachment(Bundle.class);
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        if (bundleState.isFragment()) {
            throw new IllegalStateException("Fragments cannot be added: " + bundleState);
        }
        Module module = (Module)resModule.getAttachment(Module.class);
        if (module != null) {
            AbstractBundleRevision bundleRev = (AbstractBundleRevision)resModule.getAttachment(AbstractBundleRevision.class);
            ModuleIdentifier identifier = module.getIdentifier();
            this.modules.put(identifier, bundleRev);
            this.getModuleLoaderIntegration().addModule(module);
            return identifier;
        }
        ModuleIdentifier identifier = "system.bundle".equals(resModule.getModuleId().getName()) ? this.getFrameworkModule().getIdentifier() : this.createHostModule(resModule);
        return identifier;
    }

    private ModuleIdentifier createHostModule(XModule resModule) {
        if (resModule == null) {
            throw new IllegalArgumentException("Null resModule");
        }
        Bundle bundle = (Bundle)resModule.getAttachment(Bundle.class);
        HostBundleState hostBundle = HostBundleState.assertBundleState(bundle);
        List<RevisionContent> contentRoots = hostBundle.getContentRoots();
        ModuleSpec moduleSpec = (ModuleSpec)resModule.getAttachment(ModuleSpec.class);
        if (moduleSpec == null) {
            ModuleIdentifier identifier = this.getModuleIdentifier(resModule);
            ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)identifier);
            ArrayList<DependencySpec> moduleDependencies = new ArrayList<DependencySpec>();
            SystemPathsProvider plugin = (SystemPathsProvider)this.injectedSystemPaths.getValue();
            Set<String> bootPaths = plugin.getBootDelegationPaths();
            PathFilter bootFilter = plugin.getBootDelegationFilter();
            PathFilter acceptAll = PathFilters.acceptAll();
            moduleDependencies.add(DependencySpec.createSystemDependencySpec((PathFilter)bootFilter, (PathFilter)acceptAll, bootPaths));
            LinkedHashMap<XModule, ModuleDependencyHolder> specHolderMap = new LinkedHashMap<XModule, ModuleDependencyHolder>();
            this.processModuleWires(resModule.getWires(), specHolderMap);
            HashSet allPaths = new HashSet();
            List<FragmentBundleRevision> fragRevs = hostBundle.getCurrentRevision().getAttachedFragments();
            for (FragmentBundleRevision fragRev : fragRevs) {
                List fragWires = fragRev.getResolverModule().getWires();
                this.processModuleWires(fragWires, specHolderMap);
            }
            for (ModuleDependencyHolder holder : specHolderMap.values()) {
                moduleDependencies.add(holder.create());
            }
            for (DependencySpec dep : moduleDependencies) {
                specBuilder.addDependency(dep);
            }
            for (RevisionContent revContent : contentRoots) {
                RevisionContentResourceLoader resLoader = new RevisionContentResourceLoader(revContent);
                specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resLoader));
                allPaths.addAll(resLoader.getPaths());
            }
            for (FragmentBundleRevision fragRev : fragRevs) {
                for (RevisionContent revContent : fragRev.getContentList()) {
                    RevisionContentResourceLoader resLoader = new RevisionContentResourceLoader(revContent);
                    specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resLoader));
                    allPaths.addAll(resLoader.getPaths());
                }
            }
            HashSet<String> importedPaths = new HashSet<String>();
            for (ModuleDependencyHolder holder : specHolderMap.values()) {
                Set<String> paths = holder.getImportPaths();
                if (paths == null) continue;
                importedPaths.addAll(paths);
            }
            PathFilter importFilter = acceptAll;
            PathFilter exportFilter = acceptAll;
            if (!importedPaths.isEmpty()) {
                importFilter = PathFilters.not((PathFilter)PathFilters.in(importedPaths));
            }
            PathFilter resImportFilter = PathFilters.acceptAll();
            PathFilter resExportFilter = PathFilters.acceptAll();
            ClassFilter classImportFilter = new ClassFilter(){

                public boolean accept(String className) {
                    return true;
                }
            };
            final PathFilter filter = this.getExportClassFilter(resModule);
            ClassFilter classExportFilter = new ClassFilter(){

                public boolean accept(String className) {
                    return filter.accept(className);
                }
            };
            DependencySpec localDep = DependencySpec.createLocalDependencySpec((PathFilter)importFilter, (PathFilter)exportFilter, (PathFilter)resImportFilter, (PathFilter)resExportFilter, (ClassFilter)classImportFilter, (ClassFilter)classExportFilter);
            specBuilder.addDependency(localDep);
            this.addNativeResourceLoader(resModule, specBuilder);
            PathFilter lazyActivationFilter = this.getLazyPackagesFilter(hostBundle);
            specBuilder.setModuleClassLoaderFactory((ModuleClassLoaderFactory)new HostBundleClassLoader.Factory(hostBundle, lazyActivationFilter));
            specBuilder.setFallbackLoader((LocalLoader)new HostBundleFallbackLoader(hostBundle, identifier, importedPaths));
            moduleSpec = specBuilder.create();
        }
        AbstractBundleRevision bundleRev = (AbstractBundleRevision)resModule.getAttachment(AbstractBundleRevision.class);
        ModuleIdentifier identifier = moduleSpec.getModuleIdentifier();
        this.getModuleLoaderIntegration().addModule(moduleSpec);
        this.modules.put(identifier, bundleRev);
        return identifier;
    }

    private PathFilter getExportClassFilter(XModule resModule) {
        PathFilter includeFilter = null;
        PathFilter excludeFilter = null;
        for (XPackageCapability packageCap : resModule.getPackageCapabilities()) {
            String excludeDirective;
            String includeDirective = packageCap.getDirective("include");
            if (includeDirective != null) {
                String packageName = packageCap.getName();
                String[] patterns = includeDirective.split(",");
                ArrayList<PathFilter> includes = new ArrayList<PathFilter>();
                for (String pattern : patterns) {
                    includes.add(PathFilters.match((String)(packageName + "." + pattern)));
                }
                includeFilter = PathFilters.any(includes);
            }
            if ((excludeDirective = packageCap.getDirective("exclude")) == null) continue;
            String packageName = packageCap.getName();
            String[] patterns = excludeDirective.split(",");
            ArrayList<PathFilter> excludes = new ArrayList<PathFilter>();
            for (String pattern : patterns) {
                excludes.add(PathFilters.match((String)(packageName + "." + pattern)));
            }
            excludeFilter = PathFilters.not((PathFilter)PathFilters.any(excludes));
        }
        if (includeFilter == null && excludeFilter == null) {
            return PathFilters.acceptAll();
        }
        if (includeFilter == null) {
            includeFilter = PathFilters.acceptAll();
        }
        if (excludeFilter == null) {
            excludeFilter = PathFilters.rejectAll();
        }
        return PathFilters.all((PathFilter[])new PathFilter[]{includeFilter, excludeFilter});
    }

    private PathFilter getLazyPackagesFilter(HostBundleState hostBundle) {
        PathFilter result = PathFilters.acceptAll();
        ActivationPolicyMetaData activationPolicy = hostBundle.getActivationPolicy();
        if (activationPolicy != null) {
            List excludes;
            List includes = activationPolicy.getIncludes();
            if (includes != null) {
                HashSet<String> paths = new HashSet<String>();
                for (String packageName : includes) {
                    paths.add(packageName.replace('.', '/'));
                }
                result = PathFilters.in(paths);
            }
            if ((excludes = activationPolicy.getExcludes()) != null) {
                HashSet<String> paths = new HashSet<String>();
                for (String packageName : excludes) {
                    paths.add(packageName.replace('.', '/'));
                }
                result = includes != null ? PathFilters.all((PathFilter[])new PathFilter[]{result, PathFilters.not((PathFilter)PathFilters.in(paths))}) : PathFilters.not((PathFilter)PathFilters.in(paths));
            }
        }
        return result;
    }

    private void addNativeResourceLoader(XModule resModule, ModuleSpec.Builder specBuilder) {
        Bundle bundle = (Bundle)resModule.getAttachment(Bundle.class);
        UserBundleState userBundle = UserBundleState.assertBundleState(bundle);
        Deployment deployment = userBundle.getDeployment();
        this.addNativeResourceLoader(specBuilder, userBundle, deployment);
        UserBundleRevision rev = userBundle.getCurrentRevision();
        if (rev instanceof HostBundleRevision) {
            for (FragmentBundleRevision fragRev : ((HostBundleRevision)rev).getAttachedFragments()) {
                this.addNativeResourceLoader(specBuilder, userBundle, fragRev.getDeployment());
            }
        }
    }

    private void addNativeResourceLoader(ModuleSpec.Builder specBuilder, UserBundleState userBundle, Deployment deployment) {
        NativeLibraryMetaData libMetaData = (NativeLibraryMetaData)deployment.getAttachment(NativeLibraryMetaData.class);
        if (libMetaData != null) {
            NativeResourceLoader nativeLoader = new NativeResourceLoader();
            for (NativeLibrary library : libMetaData.getNativeLibraries()) {
                String libpath = library.getLibraryPath();
                String libfile = new File(libpath).getName();
                String libname = libfile.substring(0, libfile.lastIndexOf(46));
                NativeCodePlugin.BundleNativeLibraryProvider libProvider = new NativeCodePlugin.BundleNativeLibraryProvider(userBundle, libname, libpath);
                nativeLoader.addNativeLibrary(libProvider);
                if (!libname.startsWith("lib")) continue;
                libname = libname.substring(3);
                libProvider = new NativeCodePlugin.BundleNativeLibraryProvider(userBundle, libname, libpath);
                nativeLoader.addNativeLibrary(libProvider);
            }
            specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)nativeLoader));
        }
    }

    private void processModuleWires(List<XWire> wires, Map<XModule, ModuleDependencyHolder> depBuilderMap) {
        XModule exporter;
        ArrayList<XWire> bundleWires = new ArrayList<XWire>();
        ArrayList<XWire> packageWires = new ArrayList<XWire>();
        for (XWire wire : wires) {
            XModule host;
            XRequirement req = wire.getRequirement();
            XModule importer = wire.getImporter();
            exporter = wire.getExporter();
            if (exporter == importer || importer.isFragment() && (host = importer.getHostRequirement().getWiredCapability().getModule()) == exporter) continue;
            if (req instanceof XPackageRequirement) {
                packageWires.add(wire);
                continue;
            }
            if (!(req instanceof XRequireBundleRequirement)) continue;
            bundleWires.add(wire);
        }
        HashSet<String> importedPaths = new HashSet<String>();
        HashSet<XModule> packageExporters = new HashSet<XModule>();
        for (XWire wire : packageWires) {
            exporter = wire.getExporter();
            packageExporters.add(exporter);
            XPackageRequirement req = (XPackageRequirement)wire.getRequirement();
            ModuleDependencyHolder holder = this.getDependencyHolder(depBuilderMap, exporter);
            String path = VFSUtils.getPathFromPackageName((String)req.getName());
            holder.setOptional(req.isOptional());
            holder.addImportPath(path);
            importedPaths.add(path);
        }
        PathFilter importedPathsFilter = PathFilters.in(importedPaths);
        for (XWire wire : bundleWires) {
            XModule exporter2 = wire.getExporter();
            if (packageExporters.contains(exporter2)) continue;
            XRequireBundleRequirement req = (XRequireBundleRequirement)wire.getRequirement();
            ModuleDependencyHolder holder = this.getDependencyHolder(depBuilderMap, exporter2);
            holder.setImportFilter(PathFilters.not((PathFilter)importedPathsFilter));
            holder.setOptional(req.isOptional());
            boolean reexport = "reexport".equals(req.getVisibility());
            if (!reexport) continue;
            HashSet<String> exportedPaths = new HashSet<String>();
            for (XPackageCapability cap : exporter2.getPackageCapabilities()) {
                String path = cap.getName().replace('.', '/');
                if (importedPaths.contains(path)) continue;
                exportedPaths.add(path);
            }
            PathFilter exportedPathsFilter = PathFilters.in(exportedPaths);
            holder.setImportFilter(exportedPathsFilter);
            holder.setExportFilter(exportedPathsFilter);
        }
    }

    private ModuleDependencyHolder getDependencyHolder(Map<XModule, ModuleDependencyHolder> depBuilderMap, XModule exporter) {
        ModuleIdentifier exporterId = this.getModuleIdentifier(exporter);
        ModuleDependencyHolder holder = depBuilderMap.get(exporter);
        if (holder == null) {
            holder = new ModuleDependencyHolder(exporterId);
            depBuilderMap.put(exporter, holder);
        }
        return holder;
    }

    Module loadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        if (this.getFrameworkModule().getIdentifier().equals(identifier)) {
            return this.getFrameworkModule();
        }
        return this.getModuleLoader().loadModule(identifier);
    }

    void removeModule(ModuleIdentifier identifier) {
        this.modules.remove(identifier);
        this.getModuleLoaderIntegration().removeModule(identifier);
    }

    private Module getFrameworkModule() {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        return bundleManager.getSystemBundle().getFrameworkModule();
    }

    private class ModuleDependencyHolder {
        private DependencySpec dependencySpec;
        private ModuleIdentifier identifier;
        private Set<String> importPaths;
        private PathFilter importFilter;
        private PathFilter exportFilter;
        private boolean optional;

        ModuleDependencyHolder(ModuleIdentifier identifier) {
            this.identifier = identifier;
        }

        void addImportPath(String path) {
            this.assertNotCreated();
            if (this.importPaths == null) {
                this.importPaths = new HashSet<String>();
            }
            this.importPaths.add(path);
        }

        Set<String> getImportPaths() {
            return this.importPaths;
        }

        void setImportFilter(PathFilter importFilter) {
            this.assertNotCreated();
            this.importFilter = importFilter;
        }

        void setExportFilter(PathFilter exportFilter) {
            this.assertNotCreated();
            this.exportFilter = exportFilter;
        }

        void setOptional(boolean optional) {
            this.assertNotCreated();
            this.optional = optional;
        }

        DependencySpec create() {
            Module frameworkModule;
            if (this.exportFilter == null) {
                this.exportFilter = PathFilters.rejectAll();
            }
            if (this.importFilter == null) {
                this.importFilter = this.importPaths != null ? PathFilters.in(this.importPaths) : PathFilters.acceptAll();
            }
            ModuleLoader depLoader = (frameworkModule = ModuleManagerPlugin.this.getFrameworkModule()).getIdentifier().equals(this.identifier) ? frameworkModule.getModuleLoader() : ModuleManagerPlugin.this.getModuleLoader();
            return DependencySpec.createModuleDependencySpec((PathFilter)this.importFilter, (PathFilter)this.exportFilter, (ModuleLoader)depLoader, (ModuleIdentifier)this.identifier, (boolean)this.optional);
        }

        private void assertNotCreated() {
            if (this.dependencySpec != null) {
                throw new IllegalStateException("DependencySpec already created");
            }
        }
    }
}

