/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.webserviceref;

import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.webservices.webserviceref.SecurityActions;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.Value;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;
import org.jboss.wsf.spi.serviceref.ServiceRefHandlerFactory;

final class WSRefValueSource
extends InjectionSource
implements Value<Object> {
    private final UnifiedServiceRefMetaData serviceRef;
    private final ClassLoader classLoader;

    WSRefValueSource(UnifiedServiceRefMetaData serviceRef, ClassLoader classLoader) {
        this.serviceRef = serviceRef;
        this.classLoader = classLoader;
    }

    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        ValueManagedReferenceFactory factory = new ValueManagedReferenceFactory((Value)this);
        serviceBuilder.addInjection(injector, (Object)factory);
    }

    public Object getValue() throws IllegalStateException, IllegalArgumentException {
        ClassLoader oldCL = SecurityActions.getContextClassLoader();
        try {
            DelegateClassLoader integrationCL = new DelegateClassLoader(this.getClassLoader(), this.classLoader);
            SecurityActions.setContextClassLoader((ClassLoader)integrationCL);
            Referenceable referenceable = this.getReferenceable((ClassLoader)integrationCL);
            Class<?> clazz = Class.forName(referenceable.getReference().getFactoryClassName(), true, (ClassLoader)integrationCL);
            ObjectFactory factory = (ObjectFactory)clazz.newInstance();
            Object object = factory.getObjectInstance(referenceable.getReference(), null, null, null);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            SecurityActions.setContextClassLoader(oldCL);
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoaderProvider provider = ClassLoaderProvider.getDefaultProvider();
        if (!ServiceRefHandler.Type.JAXRPC.equals((Object)this.serviceRef.getType())) {
            return provider.getServerIntegrationClassLoader();
        }
        return provider.getServerJAXRPCIntegrationClassLoader();
    }

    private Referenceable getReferenceable(ClassLoader loader) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        ServiceRefHandler serviceRefHandler = ((ServiceRefHandlerFactory)spiProvider.getSPI(ServiceRefHandlerFactory.class, loader)).getServiceRefHandler();
        return serviceRefHandler.createReferenceable(this.serviceRef);
    }
}

