/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.modcluster.ContextHost;
import org.jboss.as.modcluster.ModCluster;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class ModClusterDisableContext
implements OperationStepHandler,
DescriptionProvider {
    static final ModClusterDisableContext INSTANCE = new ModClusterDisableContext();

    public ModelNode getModelDescription(Locale locale) {
        return ModClusterSubsystemDescriptions.getDisableContextDescription(locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer() && context.getServiceRegistry(false).getService(ModClusterService.NAME) != null) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(ModClusterService.NAME);
                    ModCluster modcluster = (ModCluster)controller.getValue();
                    ModClusterLogger.ROOT_LOGGER.debugf("disable-context: %s", operation);
                    ContextHost contexthost = new ContextHost(operation);
                    modcluster.disableContext(contexthost.webhost, contexthost.webcontext);
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

