/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.QNameTarget;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Target;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.WsuIdResolver;
import org.jboss.ws.extensions.security.WsuIdTarget;
import org.jboss.ws.extensions.security.element.Reference;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.SecurityTokenReference;
import org.jboss.ws.extensions.security.element.Signature;
import org.jboss.ws.extensions.security.element.X509Token;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.operation.EncodingOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureOperation
implements EncodingOperation {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SignatureOperation.class);
    private List<Target> targets;
    private String alias;
    private String tokenRefType;
    private String securityDomainAliasLabel;

    public SignatureOperation(List<Target> targets, String alias, String tokenRefType, String securityDomainAliasLabel) {
        this.targets = targets;
        this.alias = alias;
        this.tokenRefType = tokenRefType;
        this.securityDomainAliasLabel = securityDomainAliasLabel;
    }

    private void processTarget(XMLSignature sig, Document message, Target target) {
        if (target instanceof QNameTarget) {
            this.processQNameTarget(sig, message, (QNameTarget)target);
        } else if (target instanceof WsuIdTarget) {
            this.processWsuIdTarget(sig, message, (WsuIdTarget)target);
        } else {
            throw new NotImplementedException();
        }
    }

    private void processQNameTarget(XMLSignature sig, Document message, QNameTarget target) {
        QName name = target.getName();
        Transforms transforms = new Transforms(message);
        try {
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        catch (TransformationException e) {
            throw new RuntimeException(e);
        }
        Element element = Util.findElement(message.getDocumentElement(), name);
        if (element == null) {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_FIND_ELEMENT", (Object[])new Object[0]));
        }
        String id = Util.assignWsuId(element);
        try {
            sig.addDocument("#" + id, transforms);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException(e);
        }
    }

    private void processWsuIdTarget(XMLSignature sig, Document message, WsuIdTarget target) {
        String id = target.getId();
        Transforms transforms = new Transforms(message);
        try {
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        catch (TransformationException e) {
            throw new RuntimeException(e);
        }
        try {
            sig.addDocument("#" + id, transforms);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void process(Document message, SecurityHeader header, SecurityStore store) throws WSSecurityException {
        XMLSignature sig;
        Element envelope = message.getDocumentElement();
        try {
            sig = new XMLSignature(message, null, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_BUILDING_SIGNATURE", (Object[])new Object[0]), e);
        }
        sig.addResourceResolver((ResourceResolverSpi)new WsuIdResolver(message, header.getElement()));
        PrivateKey key = store.getPrivateKey(this.alias, this.securityDomainAliasLabel);
        if (this.targets == null || this.targets.size() == 0) {
            String namespace = envelope.getNamespaceURI();
            this.processTarget(sig, message, new QNameTarget(new QName(namespace, "Body")));
            if (header.getTimestamp() != null) {
                this.processTarget(sig, message, new WsuIdTarget("timestamp"));
            }
        } else {
            for (Target target : this.targets) {
                this.processTarget(sig, message, target);
            }
        }
        try {
            sig.sign((Key)key);
        }
        catch (XMLSignatureException e) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_SIGNING_MESSAGE", (Object[])new Object[]{e.getMessage()}), e);
        }
        X509Certificate cert = store.getCertificate(this.alias, this.securityDomainAliasLabel);
        X509Token token = (X509Token)header.getSharedToken(cert);
        if (token == null) {
            token = new X509Token(cert, message);
            if (this.tokenRefType == null || "directReference".equals(this.tokenRefType)) {
                header.addToken(token);
            }
        }
        SecurityTokenReference reference = new SecurityTokenReference(Reference.getReference(this.tokenRefType, message, token));
        sig.getKeyInfo().addUnknownElement(reference.getElement());
        header.addSecurityProcess(new Signature(sig));
    }
}

