/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jpa.hibernate4.management.CollectionMetricsHandler;
import org.jboss.as.jpa.hibernate4.management.HibernateDescriptions;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;
import org.jboss.dmr.ModelType;

public class CollectionResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition LOAD_COUNT = new SimpleAttributeDefinitionBuilder("collection-load-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition FETCH_COUNT = new SimpleAttributeDefinitionBuilder("collection-fetch-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition RECREATE_COUNT = new SimpleAttributeDefinitionBuilder("collection-recreated-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition REMOVE_COUNT = new SimpleAttributeDefinitionBuilder("collection-remove-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition UPDATE_COUNT = new SimpleAttributeDefinitionBuilder("collection-update-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    private final PersistenceUnitServiceRegistry persistenceUnitRegistry;

    CollectionResourceDefinition(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        super(PathElement.pathElement((String)"collection"), HibernateDescriptions.getResourceDescriptionResolver("hibernate.statistics.collection"));
        this.persistenceUnitRegistry = persistenceUnitRegistry;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerMetric((AttributeDefinition)LOAD_COUNT, (OperationStepHandler)CollectionMetricsHandler.getLoadCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)FETCH_COUNT, (OperationStepHandler)CollectionMetricsHandler.getFetchCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)RECREATE_COUNT, (OperationStepHandler)CollectionMetricsHandler.getRecreateCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)REMOVE_COUNT, (OperationStepHandler)CollectionMetricsHandler.getRemoveCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)UPDATE_COUNT, (OperationStepHandler)CollectionMetricsHandler.getUpdateCount(this.persistenceUnitRegistry));
    }
}

