/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.cmp.CmpConfig;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.bridge.EntityBridgeInvocationHandler;
import org.jboss.as.cmp.bridge.FieldBridge;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.ejbql.Catalog;
import org.jboss.as.cmp.jdbc.JDBCActivateEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCCommandFactory;
import org.jboss.as.cmp.jdbc.JDBCCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCDeleteRelationsCommand;
import org.jboss.as.cmp.jdbc.JDBCDestroyCommand;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.JDBCFindEntitiesCommand;
import org.jboss.as.cmp.jdbc.JDBCFindEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCInitCommand;
import org.jboss.as.cmp.jdbc.JDBCInitEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCInsertRelationsCommand;
import org.jboss.as.cmp.jdbc.JDBCIsModifiedCommand;
import org.jboss.as.cmp.jdbc.JDBCLoadEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCLoadRelationCommand;
import org.jboss.as.cmp.jdbc.JDBCPassivateEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCPostCreateEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCQueryManager;
import org.jboss.as.cmp.jdbc.JDBCRemoveEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCStartCommand;
import org.jboss.as.cmp.jdbc.JDBCStopCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreEntityCommand;
import org.jboss.as.cmp.jdbc.JDBCTypeFactory;
import org.jboss.as.cmp.jdbc.ReadAheadCache;
import org.jboss.as.cmp.jdbc.RelationData;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCSelectorBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactory;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactoryRegistry;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.TransactionLocal;

public final class JDBCStoreManager
implements JDBCEntityPersistenceStore {
    private Logger log = Logger.getLogger(JDBCStoreManager.class);
    private final DeploymentUnit deploymentUnit;
    private final JDBCEntityMetaData metaData;
    private final CmpConfig cmpConfig;
    private InjectedValue<CmpEntityBeanComponent> component = new InjectedValue();
    private JDBCEntityBridge entityBridge;
    private JDBCTypeFactory typeFactory;
    private JDBCQueryManager queryManager;
    private JDBCCommandFactory commandFactory;
    private ReadAheadCache readAheadCache;
    private EntityBridgeInvocationHandler bridgeInvocationHandler;
    private final Map<String, InjectedValue<DataSource>> dataSources = new HashMap<String, InjectedValue<DataSource>>();
    private final InjectedValue<KeyGeneratorFactoryRegistry> keyGeneratorFactoryRegistry = new InjectedValue();
    private final Catalog catalog;
    private JDBCInitCommand initCommand;
    private JDBCStartCommand startCommand;
    private JDBCStopCommand stopCommand;
    private JDBCDestroyCommand destroyCommand;
    private JDBCInitEntityCommand initEntityCommand;
    private JDBCFindEntityCommand findEntityCommand;
    private JDBCFindEntitiesCommand findEntitiesCommand;
    private JDBCCreateCommand createEntityCommand;
    private JDBCPostCreateEntityCommand postCreateEntityCommand;
    private JDBCRemoveEntityCommand removeEntityCommand;
    private JDBCLoadEntityCommand loadEntityCommand;
    private JDBCIsModifiedCommand isModifiedCommand;
    private JDBCStoreEntityCommand storeEntityCommand;
    private JDBCActivateEntityCommand activateEntityCommand;
    private JDBCPassivateEntityCommand passivateEntityCommand;
    private JDBCLoadRelationCommand loadRelationCommand;
    private JDBCDeleteRelationsCommand deleteRelationsCommand;
    private JDBCInsertRelationsCommand insertRelationsCommand;
    private TransactionManager tm;
    private TransactionLocal cascadeDeleteSet;
    public static final AttachmentKey<Object> TX_DATA_MAP = AttachmentKey.create(Object.class);
    public static final AttachmentKey<AttachmentList<String>> CREATE_TABLES = AttachmentKey.createList(String.class);
    public static final AttachmentKey<AttachmentList<String>> EXISTING_TABLES = AttachmentKey.createList(String.class);

    public JDBCStoreManager(DeploymentUnit deploymentUnit, JDBCEntityMetaData metaData, CmpConfig cmpConfig, Catalog catalog) {
        this.deploymentUnit = deploymentUnit;
        this.metaData = metaData;
        this.cmpConfig = cmpConfig;
        this.catalog = catalog;
    }

    void initStoreManager() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing CMP plugin for " + this.metaData.getName()));
        }
        this.typeFactory = new JDBCTypeFactory(this.metaData.getTypeMapping(), this.metaData.getJDBCApplication().getValueClasses(), this.metaData.getJDBCApplication().getUserTypeMappings());
        this.entityBridge = new JDBCEntityBridge(this.metaData, this);
        this.entityBridge.init();
        this.bridgeInvocationHandler = new EntityBridgeInvocationHandler(this.createFieldMap(), this.createSelectorMap());
        this.getCatalog().addEntity(this.entityBridge);
        this.readAheadCache = new ReadAheadCache(this);
        this.readAheadCache.create();
        this.commandFactory = new JDBCCommandFactory(this);
        this.initCommand = this.commandFactory.createInitCommand();
        this.initCommand.execute();
    }

    void startStoreManager() throws Exception {
        this.tm = this.getComponent().getTransactionManager();
        this.cascadeDeleteSet = new TransactionLocal(this.tm){

            protected Object initialValue() {
                return new CascadeDeleteRegistry();
            }

            public Transaction getTransaction() {
                try {
                    return this.transactionManager.getTransaction();
                }
                catch (SystemException e) {
                    throw CmpMessages.MESSAGES.errorGettingCurrentTransaction(e);
                }
            }
        };
        this.entityBridge.start();
        this.startCommand = this.commandFactory.createStartCommand();
        this.stopCommand = this.commandFactory.createStopCommand();
        this.destroyCommand = this.commandFactory.createDestroyCommand();
        this.initEntityCommand = this.commandFactory.createInitEntityCommand();
        this.findEntityCommand = this.commandFactory.createFindEntityCommand();
        this.findEntitiesCommand = this.commandFactory.createFindEntitiesCommand();
        this.createEntityCommand = this.commandFactory.createCreateEntityCommand();
        this.postCreateEntityCommand = this.commandFactory.createPostCreateEntityCommand();
        this.removeEntityCommand = this.commandFactory.createRemoveEntityCommand();
        this.loadEntityCommand = this.commandFactory.createLoadEntityCommand();
        this.isModifiedCommand = this.commandFactory.createIsModifiedCommand();
        this.storeEntityCommand = this.commandFactory.createStoreEntityCommand();
        this.activateEntityCommand = this.commandFactory.createActivateEntityCommand();
        this.passivateEntityCommand = this.commandFactory.createPassivateEntityCommand();
        this.loadRelationCommand = this.commandFactory.createLoadRelationCommand();
        this.deleteRelationsCommand = this.commandFactory.createDeleteRelationsCommand();
        this.insertRelationsCommand = this.commandFactory.createInsertRelationsCommand();
        this.queryManager = new JDBCQueryManager(this);
        this.startCommand.execute();
        this.queryManager.start();
        this.readAheadCache.start();
    }

    void resolveRelationships() {
        this.entityBridge.resolveRelationships();
    }

    void addForeignKeyConstraints() {
        this.startCommand.addForeignKeyConstraints();
    }

    void stopStoreManager() {
        this.stopCommand.execute();
        this.readAheadCache.stop();
    }

    void destroy() {
        if (this.destroyCommand != null) {
            this.destroyCommand.execute();
        }
        if (this.readAheadCache != null) {
            this.readAheadCache.destroy();
        }
        this.readAheadCache = null;
        if (this.queryManager != null) {
            this.queryManager.clear();
        }
        this.queryManager = null;
    }

    @Override
    public JDBCAbstractEntityBridge getEntityBridge() {
        return this.entityBridge;
    }

    @Override
    public JDBCTypeFactory getJDBCTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public JDBCEntityMetaData getMetaData() {
        return this.metaData;
    }

    public JDBCQueryManager getQueryManager() {
        return this.queryManager;
    }

    public JDBCCommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public ReadAheadCache getReadAheadCache() {
        return this.readAheadCache;
    }

    private Map<Object, Object> getApplicationTxDataMap() {
        HashMap txDataMap = (HashMap)this.deploymentUnit.getAttachment(TX_DATA_MAP);
        if (txDataMap == null) {
            txDataMap = new HashMap();
            this.deploymentUnit.putAttachment(TX_DATA_MAP, txDataMap);
        }
        try {
            int status;
            Transaction tx = this.tm.getTransaction();
            if (tx == null) {
                return null;
            }
            HashMap txMap = (HashMap)txDataMap.get(tx);
            if (txMap == null && ((status = tx.getStatus()) == 0 || status == 7)) {
                txMap = new HashMap();
                txDataMap.put(tx, txMap);
            }
            return txMap;
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorGettingTxMap(e);
        }
    }

    public void scheduleCascadeDelete(List pks) {
        CascadeDeleteRegistry registry = (CascadeDeleteRegistry)this.cascadeDeleteSet.get();
        registry.scheduleAll(pks);
    }

    public boolean unscheduledCascadeDelete(Object pk) {
        CascadeDeleteRegistry registry = (CascadeDeleteRegistry)this.cascadeDeleteSet.get();
        return registry.unschedule(pk);
    }

    public Object getApplicationTxData(Object key) {
        Map<Object, Object> map = this.getApplicationTxDataMap();
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public void putApplicationTxData(Object key, Object value) {
        Map<Object, Object> map = this.getApplicationTxDataMap();
        if (map != null) {
            map.put(key, value);
        }
    }

    private Map getEntityTxDataMap() {
        HashMap entityTxDataMap = (HashMap)this.getApplicationTxData(this);
        if (entityTxDataMap == null) {
            entityTxDataMap = new HashMap();
            this.putApplicationTxData(this, entityTxDataMap);
        }
        return entityTxDataMap;
    }

    public Object getEntityTxData(Object key) {
        return this.getEntityTxDataMap().get(key);
    }

    public void putEntityTxData(Object key, Object value) {
        this.getEntityTxDataMap().put(key, value);
    }

    public void removeEntityTxData(Object key) {
        this.getEntityTxDataMap().remove(key);
    }

    @Override
    public CmpEntityBeanComponent getComponent() {
        return (CmpEntityBeanComponent)((Object)this.component.getValue());
    }

    public Injector<CmpEntityBeanComponent> getComponentInjector() {
        return this.component;
    }

    @Override
    public Object createBeanClassInstance() throws Exception {
        return null;
    }

    @Override
    public void initEntity(CmpEntityBeanContext ctx) {
        this.initEntityCommand.execute(ctx);
    }

    @Override
    public Object createEntity(Method createMethod, Object[] args, CmpEntityBeanContext ctx) throws CreateException {
        Object pk = this.createEntityCommand.execute(createMethod, args, ctx);
        if (pk == null) {
            throw CmpMessages.MESSAGES.pkIsNullForCreatedInstance();
        }
        return pk;
    }

    @Override
    public Object postCreateEntity(Method createMethod, Object[] args, CmpEntityBeanContext ctx) {
        return this.postCreateEntityCommand.execute(createMethod, args, ctx);
    }

    @Override
    public Object findEntity(Method finderMethod, Object[] args, CmpEntityBeanContext ctx, JDBCQueryCommand.EntityProxyFactory factory) throws FinderException {
        return this.findEntityCommand.execute(finderMethod, args, ctx, factory);
    }

    @Override
    public Collection findEntities(Method finderMethod, Object[] args, CmpEntityBeanContext ctx, JDBCQueryCommand.EntityProxyFactory factory) throws FinderException {
        return this.findEntitiesCommand.execute(finderMethod, args, ctx, factory);
    }

    @Override
    public void activateEntity(CmpEntityBeanContext ctx) {
        this.activateEntityCommand.execute(ctx);
    }

    @Override
    public void loadEntity(CmpEntityBeanContext ctx) {
        this.loadEntity(ctx, true);
    }

    public boolean loadEntity(CmpEntityBeanContext ctx, boolean failIfNotFound) {
        if (!ctx.isValid()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("RESET PERSISTENCE CONTEXT: id=" + ctx.getPrimaryKey()));
            }
            this.entityBridge.resetPersistenceContext(ctx);
        }
        JDBCEntityBridge.setCreated(ctx);
        return this.loadEntityCommand.execute(ctx, failIfNotFound);
    }

    public void loadField(JDBCCMPFieldBridge field, CmpEntityBeanContext ctx) {
        this.loadEntityCommand.execute(field, ctx);
    }

    @Override
    public boolean isStoreRequired(CmpEntityBeanContext ctx) {
        return this.isModifiedCommand.execute(ctx);
    }

    @Override
    public boolean isModified(CmpEntityBeanContext ctx) {
        return this.entityBridge.isModified(ctx);
    }

    @Override
    public void storeEntity(CmpEntityBeanContext ctx) {
        this.storeEntityCommand.execute(ctx);
        this.synchronizeRelationData();
    }

    private void synchronizeRelationData() {
        JDBCCMRFieldBridge[] cmrFields = (JDBCCMRFieldBridge[])this.entityBridge.getCMRFields();
        for (int i = 0; i < cmrFields.length; ++i) {
            JDBCCMRFieldBridge.RelationDataManager relationManager = cmrFields[i].getRelationDataManager();
            if (!relationManager.isDirty()) continue;
            RelationData relationData = relationManager.getRelationData();
            this.deleteRelations(relationData);
            this.insertRelations(relationData);
            relationData.addedRelations.clear();
            relationData.removedRelations.clear();
            relationData.notRelatedPairs.clear();
        }
    }

    @Override
    public void passivateEntity(CmpEntityBeanContext ctx) {
        this.passivateEntityCommand.execute(ctx);
    }

    @Override
    public void removeEntity(CmpEntityBeanContext ctx) throws RemoveException, RemoteException {
        this.removeEntityCommand.execute(ctx);
    }

    public Collection loadRelation(JDBCCMRFieldBridge cmrField, Object pk) {
        return this.loadRelationCommand.execute(cmrField, pk);
    }

    private void deleteRelations(RelationData relationData) {
        this.deleteRelationsCommand.execute(relationData);
    }

    private void insertRelations(RelationData relationData) {
        this.insertRelationsCommand.execute(relationData);
    }

    @Override
    public DataSource getDataSource(String name) {
        Value value = (Value)this.dataSources.get(name);
        if (value == null) {
            throw CmpMessages.MESSAGES.canNotFindDataSource(name);
        }
        DataSource dataSource = (DataSource)value.getValue();
        if (dataSource == null) {
            throw CmpMessages.MESSAGES.canNotFindDataSource(name);
        }
        return dataSource;
    }

    @Override
    public CmpConfig getCmpConfig() {
        return this.cmpConfig;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public boolean hasCreateTable(String entityName) {
        List tables = (List)this.deploymentUnit.getAttachment(CREATE_TABLES);
        return tables != null && tables.contains(entityName);
    }

    @Override
    public void addCreateTable(String entityName) {
        this.deploymentUnit.addToAttachmentList(CREATE_TABLES, (Object)entityName);
    }

    @Override
    public void addExistingTable(String entityName) {
        this.deploymentUnit.addToAttachmentList(EXISTING_TABLES, (Object)entityName);
    }

    public Injector<DataSource> getDataSourceInjector(String name) {
        InjectedValue injector = new InjectedValue();
        this.dataSources.put(name, (InjectedValue<DataSource>)injector);
        return injector;
    }

    @Override
    public EntityBridgeInvocationHandler getInvocationHandler() {
        return this.bridgeInvocationHandler;
    }

    private Map<String, Method> getAbstractAccessors() {
        Method[] methods = this.entityBridge.getMetaData().getEntityClass().getMethods();
        HashMap<String, Method> abstractAccessors = new HashMap<String, Method>(methods.length);
        for (Method method : methods) {
            String methodName;
            if (!Modifier.isAbstract(method.getModifiers()) || !(methodName = method.getName()).startsWith("get") && !methodName.startsWith("set")) continue;
            abstractAccessors.put(methodName, method);
        }
        return abstractAccessors;
    }

    private Map<String, EntityBridgeInvocationHandler.BridgeInvoker> createFieldMap() {
        Map<String, Method> abstractAccessors = this.getAbstractAccessors();
        List<FieldBridge> fields = this.entityBridge.getFields();
        HashMap<String, EntityBridgeInvocationHandler.BridgeInvoker> map = new HashMap<String, EntityBridgeInvocationHandler.BridgeInvoker>(fields.size() * 2);
        for (FieldBridge field : fields) {
            String fieldName = field.getFieldName();
            String fieldBaseName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String getterName = "get" + fieldBaseName;
            String setterName = "set" + fieldBaseName;
            Method getterMethod = abstractAccessors.get(getterName);
            Method setterMethod = abstractAccessors.get(setterName);
            if (getterMethod != null && setterMethod == null) {
                throw CmpMessages.MESSAGES.getterNotFoundForField(fieldName, this.entityBridge.getEntityName());
            }
            if (getterMethod == null && setterMethod != null) {
                throw CmpMessages.MESSAGES.setterNotFoundForField(fieldName, this.entityBridge.getEntityName());
            }
            if (getterMethod == null || setterMethod == null) continue;
            map.put(getterMethod.getName(), new EntityBridgeInvocationHandler.FieldGetInvoker(field));
            map.put(setterMethod.getName(), new EntityBridgeInvocationHandler.FieldSetInvoker(field));
            abstractAccessors.remove(getterName);
            abstractAccessors.remove(setterName);
        }
        return Collections.unmodifiableMap(map);
    }

    private Map<Method, EntityBridgeInvocationHandler.BridgeInvoker> createSelectorMap() {
        Collection<JDBCSelectorBridge> selectors = this.entityBridge.getSelectors();
        HashMap<Method, JDBCSelectorBridge> map = new HashMap<Method, JDBCSelectorBridge>(selectors.size());
        for (JDBCSelectorBridge selector : selectors) {
            map.put(selector.getMethod(), selector);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public KeyGeneratorFactory getKeyGeneratorFactory(String name) {
        return ((KeyGeneratorFactoryRegistry)this.keyGeneratorFactoryRegistry.getValue()).getFactory(name);
    }

    public Injector<KeyGeneratorFactoryRegistry> getKeyGeneratorFactoryInjector() {
        return this.keyGeneratorFactoryRegistry;
    }

    private final class CascadeDeleteRegistry {
        private Set scheduled;

        private CascadeDeleteRegistry() {
        }

        public void scheduleAll(List pks) {
            if (this.scheduled == null) {
                this.scheduled = new HashSet();
            }
            this.scheduled.addAll(pks);
        }

        public boolean unschedule(Object pk) {
            return this.scheduled.remove(pk);
        }
    }
}

