/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class RaRemove
extends RaOperationUtil
implements OperationStepHandler {
    static final RaRemove INSTANCE = new RaRemove();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        final String raName = PathAddress.pathAddress((ModelNode)opAddr).getLastElement().getValue();
        ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
        final String archive = model.get(Constants.ARCHIVE.getName()).asString();
        ModelNode compensating = Util.getEmptyOperation((String)"add", (ModelNode)opAddr);
        if (model.hasDefined("resource-adapters")) {
            for (ModelNode raNode : model.get("resource-adapters").asList()) {
                ModelNode raCompensatingNode = raNode.clone();
                compensating.get("resource-adapters").add(raCompensatingNode);
            }
        }
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                RaOperationUtil.deactivateIfActive(context, archive);
                ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName});
                List serviceNameList = context.getServiceRegistry(false).getServiceNames();
                for (ServiceName name : serviceNameList) {
                    if (raServiceName.isParentOf(name)) {
                        context.removeService(name);
                    }
                    context.removeService(ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName}));
                }
                if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                    // empty if block
                }
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }
}

